// name   : Recorder.cs
// author : Harald Maier
// date   : 19.11.2003
//
//
// This program is free software; you can redistribute it and/or modify  
// it under the terms of the GNU General Public License as published by  
// the Free Software Foundation; either version 2 of the License, or     
// (at your option) any later version.                                   

using System;
using System.Windows.Forms;
using System.Threading;
using System.Collections;
using System.Text.RegularExpressions;
using Microsoft.Win32;

using SoaringDotNET.Recorders;
using SoaringDotNET.Dialogs;
using SoaringDotNET.GUI;
using SoaringDotNET.Data;
using SerialPorts;

namespace SoaringDotNET.Controls
{
	/// <summary>
	/// 
	/// </summary>
	public class Recorder : System.Windows.Forms.UserControl
	{
        private SoaringDotNet app = null;
        private System.Windows.Forms.ImageList imageListOptions;
        private System.Windows.Forms.ListView optionsList;
        private System.ComponentModel.IContainer components;
        private System.Windows.Forms.ListViewItem listViewItemConnection;
        private System.Windows.Forms.ListViewItem listViewItemFlights;
        private System.Windows.Forms.ListViewItem listViewItemTasks;
        private System.Windows.Forms.ListViewItem listViewItemWaypoints;
        private System.Windows.Forms.ListViewItem listViewItemSua;
        private System.Windows.Forms.ListViewItem listViewItemDeclaration;
        private System.Windows.Forms.ListViewItem listViewItemPilots;
        private System.Windows.Forms.Panel panelConnection;
        private System.Windows.Forms.Panel panelFlight;
        private System.Windows.Forms.Panel panelTasks;
        private System.Windows.Forms.Panel panelWaypoints;
        private System.Windows.Forms.Panel panelDeclaration;
        private ListViewItem [] listViewItems;
        private System.Windows.Forms.ComboBox comboManufacturer;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.ComboBox comboBoxPort;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.ComboBox comboBoxBaud;
        private System.Windows.Forms.Panel panelInfo;
        private System.Windows.Forms.PictureBox connectionStatusPictureBox;
        private System.Windows.Forms.ImageList imageListConnectionStatus;
        private Panel [] panels;
        private System.Windows.Forms.Label label4;
        private RecorderBase currentRecorder = null;
        private Thread workerThread;
        private System.Windows.Forms.TextBox serialNo;
        private System.Windows.Forms.ListView listViewFlightDirectory;
        private System.Windows.Forms.Button buttonCancelTransfer;
        private System.Threading.Timer timer;
        private System.Windows.Forms.ProgressBar progress;
        private System.Windows.Forms.Panel panel1;
        private System.Windows.Forms.ImageList imageListTransfer;
        private System.Windows.Forms.ColumnHeader columnNo;
        private System.Windows.Forms.ColumnHeader columnDate;
        private System.Windows.Forms.ColumnHeader columnStart;
        private System.Windows.Forms.ColumnHeader columnEnd;
        private System.Windows.Forms.ColumnHeader columnDuration;
        private System.Windows.Forms.Panel panel2;
        private System.Windows.Forms.Button buttonUploadTasks;
        private System.Windows.Forms.GroupBox groupBoxTransferOptions;
        private System.Windows.Forms.RadioButton radioButtonSecure;
        private System.Windows.Forms.RadioButton radioButtonQuick;
        private System.Windows.Forms.Button buttonSaveFlight;
        private System.Windows.Forms.Button buttonReadFlightDir;
        private System.Windows.Forms.Button buttonDownloadTasks;
        private System.Windows.Forms.Panel panel3;
        private System.Windows.Forms.Button buttonUploadWaypoints;
        private System.Windows.Forms.Button buttonDownloadWaypoints;
        private System.Windows.Forms.Panel panel4;
        private System.Windows.Forms.Button buttonUploadDeclaration;
        private System.Windows.Forms.ComboBox comboBoxCatalogues;
        private System.Windows.Forms.Label label5;
        private System.Windows.Forms.Label label6;
        private System.Windows.Forms.TextBox catalogueItems;
        private System.Windows.Forms.ListView listViewTasks;
        private System.Windows.Forms.ColumnHeader columnHeaderName;
        private System.Windows.Forms.ColumnHeader columnHeaderWaypoints;
        private System.Windows.Forms.ColumnHeader columnPilot;
        private System.Windows.Forms.ColumnHeader columnGlider;
        private System.Windows.Forms.Label label7;
        private System.Windows.Forms.ComboBox comboBoxTask;
        private System.Windows.Forms.ListView listViewTask;
        private System.Windows.Forms.ColumnHeader columnType;
        private System.Windows.Forms.ColumnHeader columnName;
        private System.Windows.Forms.ColumnHeader columnLat;
        private System.Windows.Forms.ColumnHeader columnLongitude;
        private System.Windows.Forms.Label label8;
        private System.Windows.Forms.TextBox textPilot1;
        private System.Windows.Forms.TextBox textPilot2;
        private System.Windows.Forms.Label label9;
        private System.Windows.Forms.Label label10;
        private System.Windows.Forms.ComboBox comboBoxGlider;
        private System.Windows.Forms.Label label11;
        private System.Windows.Forms.Label label12;
        private System.Windows.Forms.ComboBox comboBoxCompClass;
        private System.Windows.Forms.TextBox textBoxGliderId;
        private System.Windows.Forms.Label label13;
        private System.Windows.Forms.TextBox textBoxCompId;
        private System.Windows.Forms.Button buttonSelectPilot1;
        private System.Windows.Forms.Button buttonSelectPilot2;
        private System.Windows.Forms.Label labelTaskType;
        private System.Windows.Forms.ColumnHeader columnHeaderType;
        private System.Windows.Forms.ColumnHeader columnFileName;
        private System.Windows.Forms.Button buttonConnect;
        private bool abort;
        private System.Windows.Forms.Label label14;
        private System.Windows.Forms.TextBox textBoxDescription;
        private System.Windows.Forms.Label label15;
        private System.Windows.Forms.TextBox visibleCatalogueItems;
        private System.Windows.Forms.Panel panelSUA;
        private System.Windows.Forms.Panel panel6;
        private System.Windows.Forms.Button buttonUploadSUA;
        private System.Windows.Forms.RadioButton radioButtonCountry;
        private System.Windows.Forms.CheckedListBox checkedListBoxCountry;
        private System.Windows.Forms.RadioButton radioButtonArea;
        private System.Windows.Forms.GroupBox groupBoxArea;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLonTo;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLatTo;
        private System.Windows.Forms.Label label16;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLonFrom;
        private SoaringDotNET.Controls.CoordEditControl coordEditControlLatFrom;
        private System.Windows.Forms.Label label17;
        private string flightPath;
        private WgsArea area;
        private System.Windows.Forms.GroupBox groupBox1;
        Hashtable selectedCountries;
        private System.Windows.Forms.ListView listViewSUAs;
        private System.Windows.Forms.ColumnHeader columnSUAName;
        private System.Windows.Forms.ColumnHeader columnSUAId;
        private System.Windows.Forms.ColumnHeader columnSUAClass;
        private System.Windows.Forms.ColumnHeader columnSUAType;
        private System.Windows.Forms.ColumnHeader columnSUABase;
        private System.Windows.Forms.ColumnHeader columnSUATop;
        private System.Windows.Forms.ColumnHeader columnSUARemark;
        private System.Windows.Forms.Panel panelSUATop;
        private System.Windows.Forms.Label labelSUAItems;
        private System.Windows.Forms.Label label19;
        private System.Windows.Forms.Panel panelSUABottom;
        private System.Windows.Forms.ColumnHeader columnSUAComm;
        private System.Windows.Forms.ColumnHeader columnSUAFrequency;
        private System.Windows.Forms.Button buttonReloadTasks;
        private System.Windows.Forms.Panel panel5;
        private System.Windows.Forms.CheckBox checkBoxRedirectToFile;
        private System.Windows.Forms.Panel panelDescription;
        private System.Windows.Forms.Panel panelTop;
        private System.Windows.Forms.Button buttonUseAllCountries;
        private System.Windows.Forms.Button buttonUseAllAirspaces;
        Hashtable selectedAirspaces;
        Hashtable selectedClasses;
        private System.Windows.Forms.Panel panelPilots;
        private System.Windows.Forms.ListBox listBoxPilots;
        private System.Windows.Forms.Panel panel7;
        private System.Windows.Forms.Button buttonUploadPilots;
        private System.Windows.Forms.Button buttonDownloadPilots;
        private System.Windows.Forms.Panel panel8;
        private System.Windows.Forms.Panel panel9;
        private System.Windows.Forms.Button button1;
        private System.Windows.Forms.CheckedListBox checkedListBoxAirspaces;
        private System.Windows.Forms.GroupBox groupBox2;
        private System.Windows.Forms.Button buttonUseAllClasses;
        private System.Windows.Forms.CheckedListBox checkedListBoxClasses;
        private System.Windows.Forms.CheckBox checkBoxUseMapCoord;
        private bool refresh;

        public Recorder()
		{
			// 
			// TODO: Add constructor logic here
			//
            InitializeComponent();

            columnHeaderWaypoints.Width = listViewTasks.Width - columnHeaderName.Width;
            listViewItemConnection = new System.Windows.Forms.ListViewItem("Connection", 0);
            listViewItemFlights = new System.Windows.Forms.ListViewItem("Flights", 1);
            listViewItemTasks = new System.Windows.Forms.ListViewItem("Tasks", 2);
            listViewItemWaypoints = new System.Windows.Forms.ListViewItem("Waypoints", 3);
            listViewItemDeclaration = new System.Windows.Forms.ListViewItem("Declaration", 4);
            listViewItemPilots = new System.Windows.Forms.ListViewItem("Pilots", 5);
            listViewItemSua = new System.Windows.Forms.ListViewItem("SUA", 6);

            listViewItems = new ListViewItem [] {listViewItemConnection, listViewItemFlights, listViewItemTasks,
                                                    listViewItemWaypoints, listViewItemDeclaration, 
                                                    listViewItemPilots, listViewItemSua};

            panels = new Panel [] {panelConnection, panelFlight, panelTasks, panelWaypoints, panelDeclaration, panelPilots, panelSUA};

            optionsList.Items.AddRange(listViewItems);

            listViewItemConnection.Selected = true;
            listViewItemConnection.Focused = true;

            comboBoxPort.Items.AddRange(new object[] {"COM1:", "COM2:", "COM3:", "COM4:"});

            RecorderBase.SerialNoThreadNotify = new Notify(GetSerialNoHook);
            RecorderBase.FlightDirectoryThreadNotify= new Notify(GetFlightDirectoryHook);
            RecorderBase.DownloadWaypointsThreadNotify = new Notify(DownloadWaypointsHook);
            RecorderBase.UploadWaypointsThreadNotify = new Notify(UploadWaypointsHook);
            RecorderBase.DownloadTasksThreadNotify = new Notify(DownloadTasksHook);
            RecorderBase.UploadTasksThreadNotify = new Notify(UploadTasksHook);
            RecorderBase.DownloadFlightsThreadNotify = new Notify(DownloadFlightsHook);
            RecorderBase.UploadDeclarationThreadNotify = new Notify(UploadDeclarationHook);
            RecorderBase.UploadSUAsThreadNotify = new Notify(UploadSUAsHook);
            RecorderBase.DownloadPilotsThreadNotify = new Notify(DownloadPilotsHook);
            RecorderBase.UploadPilotsThreadNotify = new Notify(UploadPilotsHook);

            // VisualStudio will fail to create objects
            try {
                comboManufacturer.Items.Add(new SoaringPilot());
                comboManufacturer.Items.Add(new Volkslogger());
                foreach (DictionaryEntry entry in AppContents.gliderIndexes) {
                    comboBoxGlider.Items.Add(entry.Value);
                }

                comboBoxCompClass.Items.AddRange(AppContents.compClasses);

                foreach (IdType t in AppContents.airspaceTypes) {
                    checkedListBoxAirspaces.Items.Add(t);
                }
                foreach (IdType c in AppContents.airspaceClasses) {
                    checkedListBoxClasses.Items.Add(c);
                }
            }
            catch {
            }
            
            selectedCountries = new Hashtable();
            selectedAirspaces = new Hashtable();
            selectedClasses = new Hashtable();

            currentRecorder = null;
            Disconnect();

            workerThread = null;
            timer = null;
            flightPath = "";
            area = new WgsArea();

            ReloadAirspaces();

            radioButtonCountry.Checked = true;

            listViewSUAs.ListViewItemSorter = new ListViewItemSorter();
            listViewFlightDirectory.ListViewItemSorter = new ListViewItemSorter();
            listViewTasks.ListViewItemSorter = new ListViewItemSorter();

            refresh = true;
        }

        #region Public Functions
        public void Add(WaypointCatalog c) {
            comboBoxCatalogues.Items.Add(c);
            comboBoxCatalogues.SelectedItem = c;
        }

        public void Add(Task t) {
            ListViewItem it = new ListViewItem(new string [] {"", "", ""});
            it.Tag = t;
            listViewTasks.Items.Add(it);
            Update(t);
            comboBoxTask.Items.Add(t);
        }

        public void Add(Pilot p) {
            listBoxPilots.Items.Add(p);
        }

        public void Remove(WaypointCatalog c) {
            int idx = comboBoxCatalogues.SelectedIndex;
            comboBoxCatalogues.Items.Remove(c);
            if (comboBoxCatalogues.Items.Count > 0) {
                comboBoxCatalogues.SelectedIndex = Math.Min(idx, comboBoxCatalogues.Items.Count - 1);
            }
            else {
                comboBoxCatalogues.SelectedIndex = -1;
            }
        }

        public void Remove(Pilot p) {
            listBoxPilots.Items.Remove(p);
        }

        public void Remove(Task t) {
            foreach (ListViewItem it in listViewTasks.Items) {
                if (it.Tag == t) {
                    it.Remove();
                    break;
                }
            }

            int idx = comboBoxTask.SelectedIndex;
            comboBoxTask.Items.Remove(t);
            if (comboBoxTask.Items.Count > 0) {
                comboBoxTask.SelectedIndex = Math.Min(idx, comboBoxTask.Items.Count - 1);
            }
            else {
                comboBoxTask.SelectedIndex = -1;
            }
        }

        public void ReloadAirspaces() {
            listViewSUAs.Items.Clear();
            selectedCountries.Clear();
            checkedListBoxCountry.Items.Clear();
            foreach (CountryTypeId c in AppContents.loadedAirspaceCountries) {
                checkedListBoxCountry.Items.Add(AppContents.CreateCountry(c));
            }
        }

        public void Update(WaypointCatalog c) {
            if (comboBoxCatalogues.SelectedItem == c) {
                OnCatalogueChanged(null, null);
            }
        }

        public void Update(Task t) {
            foreach (ListViewItem it in listViewTasks.Items) {
                if (it.Tag == t) {
                    string txt = "";
                    int i;
                    if (t.Count > 0) {
                        txt = t[0].longName;
                        for (i = 1; i < t.Count; i++) {
                            txt += ", " + t[i].longName;
                        }
                    }

                    it.Text = t.Name;
                    it.SubItems[1].Text = t.TaskTypeString;
                    it.SubItems[2].Text = txt;
                    break;
                }
            }

            if (comboBoxTask.SelectedItem == t) {
                OnSelectedTaskChanged(null, null);
            }
        }

        public void Update(Pilot p) {
            int idx;
            if ((idx = listBoxPilots.Items.IndexOf(p)) >= 0) {
                listBoxPilots.Items[idx] = p;
            }
        }
        #endregion

        #region Protected Functions
        protected override void Dispose(bool disposing) {
            // TODO:  Add Recorder.Dispose implementation
            Disconnect();
            base.Dispose (disposing);
        }

        #endregion

        #region Private Functions
        private void InitializeComponent() {
            this.components = new System.ComponentModel.Container();
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Recorder));
            this.imageListOptions = new System.Windows.Forms.ImageList(this.components);
            this.optionsList = new System.Windows.Forms.ListView();
            this.panelConnection = new System.Windows.Forms.Panel();
            this.panelDescription = new System.Windows.Forms.Panel();
            this.textBoxDescription = new System.Windows.Forms.TextBox();
            this.label14 = new System.Windows.Forms.Label();
            this.panelTop = new System.Windows.Forms.Panel();
            this.checkBoxRedirectToFile = new System.Windows.Forms.CheckBox();
            this.buttonConnect = new System.Windows.Forms.Button();
            this.label4 = new System.Windows.Forms.Label();
            this.serialNo = new System.Windows.Forms.TextBox();
            this.label3 = new System.Windows.Forms.Label();
            this.comboBoxBaud = new System.Windows.Forms.ComboBox();
            this.label2 = new System.Windows.Forms.Label();
            this.comboBoxPort = new System.Windows.Forms.ComboBox();
            this.label1 = new System.Windows.Forms.Label();
            this.comboManufacturer = new System.Windows.Forms.ComboBox();
            this.panelFlight = new System.Windows.Forms.Panel();
            this.listViewFlightDirectory = new System.Windows.Forms.ListView();
            this.columnNo = new System.Windows.Forms.ColumnHeader();
            this.columnDate = new System.Windows.Forms.ColumnHeader();
            this.columnPilot = new System.Windows.Forms.ColumnHeader();
            this.columnGlider = new System.Windows.Forms.ColumnHeader();
            this.columnStart = new System.Windows.Forms.ColumnHeader();
            this.columnEnd = new System.Windows.Forms.ColumnHeader();
            this.columnDuration = new System.Windows.Forms.ColumnHeader();
            this.columnFileName = new System.Windows.Forms.ColumnHeader();
            this.panel1 = new System.Windows.Forms.Panel();
            this.groupBoxTransferOptions = new System.Windows.Forms.GroupBox();
            this.radioButtonSecure = new System.Windows.Forms.RadioButton();
            this.radioButtonQuick = new System.Windows.Forms.RadioButton();
            this.buttonReadFlightDir = new System.Windows.Forms.Button();
            this.imageListTransfer = new System.Windows.Forms.ImageList(this.components);
            this.buttonSaveFlight = new System.Windows.Forms.Button();
            this.panelTasks = new System.Windows.Forms.Panel();
            this.listViewTasks = new System.Windows.Forms.ListView();
            this.columnHeaderName = new System.Windows.Forms.ColumnHeader();
            this.columnHeaderType = new System.Windows.Forms.ColumnHeader();
            this.columnHeaderWaypoints = new System.Windows.Forms.ColumnHeader();
            this.panel5 = new System.Windows.Forms.Panel();
            this.buttonReloadTasks = new System.Windows.Forms.Button();
            this.panel2 = new System.Windows.Forms.Panel();
            this.buttonUploadTasks = new System.Windows.Forms.Button();
            this.buttonDownloadTasks = new System.Windows.Forms.Button();
            this.panelWaypoints = new System.Windows.Forms.Panel();
            this.visibleCatalogueItems = new System.Windows.Forms.TextBox();
            this.label15 = new System.Windows.Forms.Label();
            this.catalogueItems = new System.Windows.Forms.TextBox();
            this.label6 = new System.Windows.Forms.Label();
            this.label5 = new System.Windows.Forms.Label();
            this.comboBoxCatalogues = new System.Windows.Forms.ComboBox();
            this.panel3 = new System.Windows.Forms.Panel();
            this.buttonUploadWaypoints = new System.Windows.Forms.Button();
            this.buttonDownloadWaypoints = new System.Windows.Forms.Button();
            this.panelDeclaration = new System.Windows.Forms.Panel();
            this.panel4 = new System.Windows.Forms.Panel();
            this.buttonUploadDeclaration = new System.Windows.Forms.Button();
            this.labelTaskType = new System.Windows.Forms.Label();
            this.buttonSelectPilot2 = new System.Windows.Forms.Button();
            this.buttonSelectPilot1 = new System.Windows.Forms.Button();
            this.textBoxCompId = new System.Windows.Forms.TextBox();
            this.label13 = new System.Windows.Forms.Label();
            this.textBoxGliderId = new System.Windows.Forms.TextBox();
            this.comboBoxCompClass = new System.Windows.Forms.ComboBox();
            this.label12 = new System.Windows.Forms.Label();
            this.label11 = new System.Windows.Forms.Label();
            this.comboBoxGlider = new System.Windows.Forms.ComboBox();
            this.label10 = new System.Windows.Forms.Label();
            this.label9 = new System.Windows.Forms.Label();
            this.textPilot2 = new System.Windows.Forms.TextBox();
            this.textPilot1 = new System.Windows.Forms.TextBox();
            this.label8 = new System.Windows.Forms.Label();
            this.listViewTask = new System.Windows.Forms.ListView();
            this.columnType = new System.Windows.Forms.ColumnHeader();
            this.columnName = new System.Windows.Forms.ColumnHeader();
            this.columnLat = new System.Windows.Forms.ColumnHeader();
            this.columnLongitude = new System.Windows.Forms.ColumnHeader();
            this.comboBoxTask = new System.Windows.Forms.ComboBox();
            this.label7 = new System.Windows.Forms.Label();
            this.panelInfo = new System.Windows.Forms.Panel();
            this.progress = new System.Windows.Forms.ProgressBar();
            this.buttonCancelTransfer = new System.Windows.Forms.Button();
            this.connectionStatusPictureBox = new System.Windows.Forms.PictureBox();
            this.imageListConnectionStatus = new System.Windows.Forms.ImageList(this.components);
            this.panelSUA = new System.Windows.Forms.Panel();
            this.panelSUABottom = new System.Windows.Forms.Panel();
            this.listViewSUAs = new System.Windows.Forms.ListView();
            this.columnSUAName = new System.Windows.Forms.ColumnHeader();
            this.columnSUAId = new System.Windows.Forms.ColumnHeader();
            this.columnSUAClass = new System.Windows.Forms.ColumnHeader();
            this.columnSUAType = new System.Windows.Forms.ColumnHeader();
            this.columnSUABase = new System.Windows.Forms.ColumnHeader();
            this.columnSUATop = new System.Windows.Forms.ColumnHeader();
            this.columnSUAComm = new System.Windows.Forms.ColumnHeader();
            this.columnSUAFrequency = new System.Windows.Forms.ColumnHeader();
            this.columnSUARemark = new System.Windows.Forms.ColumnHeader();
            this.labelSUAItems = new System.Windows.Forms.Label();
            this.panelSUATop = new System.Windows.Forms.Panel();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.checkedListBoxClasses = new System.Windows.Forms.CheckedListBox();
            this.buttonUseAllClasses = new System.Windows.Forms.Button();
            this.buttonUseAllCountries = new System.Windows.Forms.Button();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.checkedListBoxAirspaces = new System.Windows.Forms.CheckedListBox();
            this.buttonUseAllAirspaces = new System.Windows.Forms.Button();
            this.groupBoxArea = new System.Windows.Forms.GroupBox();
            this.checkBoxUseMapCoord = new System.Windows.Forms.CheckBox();
            this.coordEditControlLonTo = new SoaringDotNET.Controls.CoordEditControl();
            this.coordEditControlLatTo = new SoaringDotNET.Controls.CoordEditControl();
            this.label16 = new System.Windows.Forms.Label();
            this.coordEditControlLonFrom = new SoaringDotNET.Controls.CoordEditControl();
            this.coordEditControlLatFrom = new SoaringDotNET.Controls.CoordEditControl();
            this.label17 = new System.Windows.Forms.Label();
            this.radioButtonArea = new System.Windows.Forms.RadioButton();
            this.checkedListBoxCountry = new System.Windows.Forms.CheckedListBox();
            this.radioButtonCountry = new System.Windows.Forms.RadioButton();
            this.panel6 = new System.Windows.Forms.Panel();
            this.buttonUploadSUA = new System.Windows.Forms.Button();
            this.label19 = new System.Windows.Forms.Label();
            this.panelPilots = new System.Windows.Forms.Panel();
            this.panel8 = new System.Windows.Forms.Panel();
            this.listBoxPilots = new System.Windows.Forms.ListBox();
            this.panel9 = new System.Windows.Forms.Panel();
            this.button1 = new System.Windows.Forms.Button();
            this.panel7 = new System.Windows.Forms.Panel();
            this.buttonUploadPilots = new System.Windows.Forms.Button();
            this.buttonDownloadPilots = new System.Windows.Forms.Button();
            this.panelConnection.SuspendLayout();
            this.panelDescription.SuspendLayout();
            this.panelTop.SuspendLayout();
            this.panelFlight.SuspendLayout();
            this.panel1.SuspendLayout();
            this.groupBoxTransferOptions.SuspendLayout();
            this.panelTasks.SuspendLayout();
            this.panel5.SuspendLayout();
            this.panel2.SuspendLayout();
            this.panelWaypoints.SuspendLayout();
            this.panel3.SuspendLayout();
            this.panelDeclaration.SuspendLayout();
            this.panel4.SuspendLayout();
            this.panelInfo.SuspendLayout();
            this.panelSUA.SuspendLayout();
            this.panelSUABottom.SuspendLayout();
            this.panelSUATop.SuspendLayout();
            this.groupBox2.SuspendLayout();
            this.groupBox1.SuspendLayout();
            this.groupBoxArea.SuspendLayout();
            this.panel6.SuspendLayout();
            this.panelPilots.SuspendLayout();
            this.panel8.SuspendLayout();
            this.panel9.SuspendLayout();
            this.panel7.SuspendLayout();
            this.SuspendLayout();
            // 
            // imageListOptions
            // 
            this.imageListOptions.ImageSize = new System.Drawing.Size(32, 32);
            this.imageListOptions.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListOptions.ImageStream")));
            this.imageListOptions.TransparentColor = System.Drawing.Color.Transparent;
            // 
            // optionsList
            // 
            this.optionsList.Dock = System.Windows.Forms.DockStyle.Left;
            this.optionsList.HideSelection = false;
            this.optionsList.LargeImageList = this.imageListOptions;
            this.optionsList.Location = new System.Drawing.Point(5, 5);
            this.optionsList.MultiSelect = false;
            this.optionsList.Name = "optionsList";
            this.optionsList.Size = new System.Drawing.Size(90, 646);
            this.optionsList.TabIndex = 0;
            this.optionsList.SelectedIndexChanged += new System.EventHandler(this.OnSelectedItemChanged);
            // 
            // panelConnection
            // 
            this.panelConnection.BackColor = System.Drawing.Color.Transparent;
            this.panelConnection.Controls.Add(this.panelDescription);
            this.panelConnection.Controls.Add(this.panelTop);
            this.panelConnection.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelConnection.DockPadding.All = 5;
            this.panelConnection.Location = new System.Drawing.Point(95, 5);
            this.panelConnection.Name = "panelConnection";
            this.panelConnection.Size = new System.Drawing.Size(828, 608);
            this.panelConnection.TabIndex = 1;
            // 
            // panelDescription
            // 
            this.panelDescription.Controls.Add(this.textBoxDescription);
            this.panelDescription.Controls.Add(this.label14);
            this.panelDescription.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelDescription.DockPadding.Bottom = 10;
            this.panelDescription.DockPadding.Left = 10;
            this.panelDescription.DockPadding.Right = 10;
            this.panelDescription.Location = new System.Drawing.Point(5, 128);
            this.panelDescription.Name = "panelDescription";
            this.panelDescription.Size = new System.Drawing.Size(818, 475);
            this.panelDescription.TabIndex = 12;
            // 
            // textBoxDescription
            // 
            this.textBoxDescription.AcceptsReturn = true;
            this.textBoxDescription.AcceptsTab = true;
            this.textBoxDescription.Dock = System.Windows.Forms.DockStyle.Fill;
            this.textBoxDescription.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.textBoxDescription.Location = new System.Drawing.Point(10, 16);
            this.textBoxDescription.Multiline = true;
            this.textBoxDescription.Name = "textBoxDescription";
            this.textBoxDescription.ReadOnly = true;
            this.textBoxDescription.ScrollBars = System.Windows.Forms.ScrollBars.Both;
            this.textBoxDescription.Size = new System.Drawing.Size(798, 449);
            this.textBoxDescription.TabIndex = 10;
            this.textBoxDescription.Text = "";
            // 
            // label14
            // 
            this.label14.AutoSize = true;
            this.label14.Dock = System.Windows.Forms.DockStyle.Top;
            this.label14.Location = new System.Drawing.Point(10, 0);
            this.label14.Name = "label14";
            this.label14.Size = new System.Drawing.Size(61, 16);
            this.label14.TabIndex = 9;
            this.label14.Text = "Description";
            // 
            // panelTop
            // 
            this.panelTop.Controls.Add(this.checkBoxRedirectToFile);
            this.panelTop.Controls.Add(this.buttonConnect);
            this.panelTop.Controls.Add(this.label4);
            this.panelTop.Controls.Add(this.serialNo);
            this.panelTop.Controls.Add(this.label3);
            this.panelTop.Controls.Add(this.comboBoxBaud);
            this.panelTop.Controls.Add(this.label2);
            this.panelTop.Controls.Add(this.comboBoxPort);
            this.panelTop.Controls.Add(this.label1);
            this.panelTop.Controls.Add(this.comboManufacturer);
            this.panelTop.Dock = System.Windows.Forms.DockStyle.Top;
            this.panelTop.Location = new System.Drawing.Point(5, 5);
            this.panelTop.Name = "panelTop";
            this.panelTop.Size = new System.Drawing.Size(818, 123);
            this.panelTop.TabIndex = 13;
            // 
            // checkBoxRedirectToFile
            // 
            this.checkBoxRedirectToFile.Enabled = false;
            this.checkBoxRedirectToFile.Location = new System.Drawing.Point(416, 88);
            this.checkBoxRedirectToFile.Name = "checkBoxRedirectToFile";
            this.checkBoxRedirectToFile.TabIndex = 11;
            this.checkBoxRedirectToFile.Text = "Export to file";
            this.checkBoxRedirectToFile.CheckedChanged += new System.EventHandler(this.OnCreateFilesCheckChanged);
            // 
            // buttonConnect
            // 
            this.buttonConnect.Image = ((System.Drawing.Image)(resources.GetObject("buttonConnect.Image")));
            this.buttonConnect.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonConnect.Location = new System.Drawing.Point(416, 24);
            this.buttonConnect.Name = "buttonConnect";
            this.buttonConnect.Size = new System.Drawing.Size(96, 32);
            this.buttonConnect.TabIndex = 8;
            this.buttonConnect.Text = "Connect Recorder";
            this.buttonConnect.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonConnect.Click += new System.EventHandler(this.OnConnectRecorder);
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(16, 72);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(54, 16);
            this.label4.TabIndex = 7;
            this.label4.Text = "Serial No.";
            // 
            // serialNo
            // 
            this.serialNo.Location = new System.Drawing.Point(16, 88);
            this.serialNo.Name = "serialNo";
            this.serialNo.ReadOnly = true;
            this.serialNo.Size = new System.Drawing.Size(56, 20);
            this.serialNo.TabIndex = 6;
            this.serialNo.Text = "";
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(304, 16);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(31, 16);
            this.label3.TabIndex = 5;
            this.label3.Text = "Baud";
            // 
            // comboBoxBaud
            // 
            this.comboBoxBaud.Location = new System.Drawing.Point(304, 32);
            this.comboBoxBaud.Name = "comboBoxBaud";
            this.comboBoxBaud.Size = new System.Drawing.Size(88, 21);
            this.comboBoxBaud.TabIndex = 4;
            this.comboBoxBaud.SelectedIndexChanged += new System.EventHandler(this.OnConnectionChanged);
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(208, 16);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(25, 16);
            this.label2.TabIndex = 3;
            this.label2.Text = "Port";
            // 
            // comboBoxPort
            // 
            this.comboBoxPort.Location = new System.Drawing.Point(208, 32);
            this.comboBoxPort.Name = "comboBoxPort";
            this.comboBoxPort.Size = new System.Drawing.Size(72, 21);
            this.comboBoxPort.TabIndex = 2;
            this.comboBoxPort.SelectedIndexChanged += new System.EventHandler(this.OnConnectionChanged);
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(16, 16);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(71, 16);
            this.label1.TabIndex = 1;
            this.label1.Text = "Manufacturer";
            // 
            // comboManufacturer
            // 
            this.comboManufacturer.Location = new System.Drawing.Point(16, 32);
            this.comboManufacturer.Name = "comboManufacturer";
            this.comboManufacturer.Size = new System.Drawing.Size(176, 21);
            this.comboManufacturer.TabIndex = 0;
            this.comboManufacturer.SelectionChangeCommitted += new System.EventHandler(this.OnRecorderChanged);
            // 
            // panelFlight
            // 
            this.panelFlight.BackColor = System.Drawing.Color.Transparent;
            this.panelFlight.Controls.Add(this.listViewFlightDirectory);
            this.panelFlight.Controls.Add(this.panel1);
            this.panelFlight.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelFlight.DockPadding.All = 5;
            this.panelFlight.Location = new System.Drawing.Point(95, 5);
            this.panelFlight.Name = "panelFlight";
            this.panelFlight.Size = new System.Drawing.Size(828, 608);
            this.panelFlight.TabIndex = 2;
            // 
            // listViewFlightDirectory
            // 
            this.listViewFlightDirectory.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
                                                                                                      this.columnNo,
                                                                                                      this.columnDate,
                                                                                                      this.columnPilot,
                                                                                                      this.columnGlider,
                                                                                                      this.columnStart,
                                                                                                      this.columnEnd,
                                                                                                      this.columnDuration,
                                                                                                      this.columnFileName});
            this.listViewFlightDirectory.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listViewFlightDirectory.FullRowSelect = true;
            this.listViewFlightDirectory.GridLines = true;
            this.listViewFlightDirectory.HideSelection = false;
            this.listViewFlightDirectory.Location = new System.Drawing.Point(5, 5);
            this.listViewFlightDirectory.Name = "listViewFlightDirectory";
            this.listViewFlightDirectory.Size = new System.Drawing.Size(818, 550);
            this.listViewFlightDirectory.TabIndex = 0;
            this.listViewFlightDirectory.View = System.Windows.Forms.View.Details;
            this.listViewFlightDirectory.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.OnColumnClick);
            // 
            // columnNo
            // 
            this.columnNo.Text = "Nr.";
            this.columnNo.Width = 30;
            // 
            // columnDate
            // 
            this.columnDate.Text = "Date";
            this.columnDate.Width = 90;
            // 
            // columnPilot
            // 
            this.columnPilot.Text = "Pilot";
            this.columnPilot.Width = 180;
            // 
            // columnGlider
            // 
            this.columnGlider.Text = "Glider";
            this.columnGlider.Width = 100;
            // 
            // columnStart
            // 
            this.columnStart.Text = "Start";
            // 
            // columnEnd
            // 
            this.columnEnd.Text = "End";
            // 
            // columnDuration
            // 
            this.columnDuration.Text = "Duration";
            // 
            // columnFileName
            // 
            this.columnFileName.Text = "Filename";
            this.columnFileName.Width = 120;
            // 
            // panel1
            // 
            this.panel1.Controls.Add(this.groupBoxTransferOptions);
            this.panel1.Controls.Add(this.buttonReadFlightDir);
            this.panel1.Controls.Add(this.buttonSaveFlight);
            this.panel1.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel1.DockPadding.All = 2;
            this.panel1.Location = new System.Drawing.Point(5, 555);
            this.panel1.Name = "panel1";
            this.panel1.Size = new System.Drawing.Size(818, 48);
            this.panel1.TabIndex = 2;
            // 
            // groupBoxTransferOptions
            // 
            this.groupBoxTransferOptions.Controls.Add(this.radioButtonSecure);
            this.groupBoxTransferOptions.Controls.Add(this.radioButtonQuick);
            this.groupBoxTransferOptions.Location = new System.Drawing.Point(224, 2);
            this.groupBoxTransferOptions.Name = "groupBoxTransferOptions";
            this.groupBoxTransferOptions.Size = new System.Drawing.Size(136, 44);
            this.groupBoxTransferOptions.TabIndex = 2;
            this.groupBoxTransferOptions.TabStop = false;
            this.groupBoxTransferOptions.Text = "Transfer mode";
            // 
            // radioButtonSecure
            // 
            this.radioButtonSecure.Checked = true;
            this.radioButtonSecure.Location = new System.Drawing.Point(8, 16);
            this.radioButtonSecure.Name = "radioButtonSecure";
            this.radioButtonSecure.Size = new System.Drawing.Size(56, 16);
            this.radioButtonSecure.TabIndex = 1;
            this.radioButtonSecure.TabStop = true;
            this.radioButtonSecure.Text = "secure";
            // 
            // radioButtonQuick
            // 
            this.radioButtonQuick.Location = new System.Drawing.Point(72, 16);
            this.radioButtonQuick.Name = "radioButtonQuick";
            this.radioButtonQuick.Size = new System.Drawing.Size(56, 16);
            this.radioButtonQuick.TabIndex = 0;
            this.radioButtonQuick.Text = "quick";
            // 
            // buttonReadFlightDir
            // 
            this.buttonReadFlightDir.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonReadFlightDir.ImageIndex = 0;
            this.buttonReadFlightDir.ImageList = this.imageListTransfer;
            this.buttonReadFlightDir.Location = new System.Drawing.Point(8, 8);
            this.buttonReadFlightDir.Name = "buttonReadFlightDir";
            this.buttonReadFlightDir.Size = new System.Drawing.Size(96, 32);
            this.buttonReadFlightDir.TabIndex = 0;
            this.buttonReadFlightDir.Text = "Read flight directory";
            this.buttonReadFlightDir.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonReadFlightDir.Click += new System.EventHandler(this.OnReadFlightDirectory);
            // 
            // imageListTransfer
            // 
            this.imageListTransfer.ImageSize = new System.Drawing.Size(30, 20);
            this.imageListTransfer.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListTransfer.ImageStream")));
            this.imageListTransfer.TransparentColor = System.Drawing.Color.Magenta;
            // 
            // buttonSaveFlight
            // 
            this.buttonSaveFlight.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonSaveFlight.ImageIndex = 1;
            this.buttonSaveFlight.ImageList = this.imageListTransfer;
            this.buttonSaveFlight.Location = new System.Drawing.Point(112, 8);
            this.buttonSaveFlight.Name = "buttonSaveFlight";
            this.buttonSaveFlight.Size = new System.Drawing.Size(96, 32);
            this.buttonSaveFlight.TabIndex = 1;
            this.buttonSaveFlight.Text = "Save flight";
            this.buttonSaveFlight.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonSaveFlight.Click += new System.EventHandler(this.OnSaveFlights);
            // 
            // panelTasks
            // 
            this.panelTasks.BackColor = System.Drawing.Color.Transparent;
            this.panelTasks.Controls.Add(this.listViewTasks);
            this.panelTasks.Controls.Add(this.panel5);
            this.panelTasks.Controls.Add(this.panel2);
            this.panelTasks.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelTasks.DockPadding.All = 5;
            this.panelTasks.Location = new System.Drawing.Point(95, 5);
            this.panelTasks.Name = "panelTasks";
            this.panelTasks.Size = new System.Drawing.Size(828, 608);
            this.panelTasks.TabIndex = 3;
            // 
            // listViewTasks
            // 
            this.listViewTasks.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
                                                                                            this.columnHeaderName,
                                                                                            this.columnHeaderType,
                                                                                            this.columnHeaderWaypoints});
            this.listViewTasks.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listViewTasks.FullRowSelect = true;
            this.listViewTasks.Location = new System.Drawing.Point(5, 5);
            this.listViewTasks.Name = "listViewTasks";
            this.listViewTasks.Size = new System.Drawing.Size(818, 502);
            this.listViewTasks.TabIndex = 1;
            this.listViewTasks.View = System.Windows.Forms.View.Details;
            this.listViewTasks.KeyDown += new System.Windows.Forms.KeyEventHandler(this.OnKeyDownTasks);
            this.listViewTasks.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.OnColumnClick);
            // 
            // columnHeaderName
            // 
            this.columnHeaderName.Text = "Name";
            this.columnHeaderName.Width = 102;
            // 
            // columnHeaderType
            // 
            this.columnHeaderType.Text = "Type";
            this.columnHeaderType.Width = 180;
            // 
            // columnHeaderWaypoints
            // 
            this.columnHeaderWaypoints.Text = "Waypoints";
            this.columnHeaderWaypoints.Width = 464;
            // 
            // panel5
            // 
            this.panel5.Controls.Add(this.buttonReloadTasks);
            this.panel5.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel5.Location = new System.Drawing.Point(5, 507);
            this.panel5.Name = "panel5";
            this.panel5.Size = new System.Drawing.Size(818, 48);
            this.panel5.TabIndex = 3;
            // 
            // buttonReloadTasks
            // 
            this.buttonReloadTasks.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonReloadTasks.ImageIndex = 4;
            this.buttonReloadTasks.ImageList = this.imageListTransfer;
            this.buttonReloadTasks.Location = new System.Drawing.Point(8, 8);
            this.buttonReloadTasks.Name = "buttonReloadTasks";
            this.buttonReloadTasks.Size = new System.Drawing.Size(96, 32);
            this.buttonReloadTasks.TabIndex = 2;
            this.buttonReloadTasks.Text = "Reload            Tasks";
            this.buttonReloadTasks.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonReloadTasks.Click += new System.EventHandler(this.OnReloadTasks);
            // 
            // panel2
            // 
            this.panel2.Controls.Add(this.buttonUploadTasks);
            this.panel2.Controls.Add(this.buttonDownloadTasks);
            this.panel2.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel2.Location = new System.Drawing.Point(5, 555);
            this.panel2.Name = "panel2";
            this.panel2.Size = new System.Drawing.Size(818, 48);
            this.panel2.TabIndex = 0;
            // 
            // buttonUploadTasks
            // 
            this.buttonUploadTasks.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonUploadTasks.ImageIndex = 2;
            this.buttonUploadTasks.ImageList = this.imageListTransfer;
            this.buttonUploadTasks.Location = new System.Drawing.Point(112, 8);
            this.buttonUploadTasks.Name = "buttonUploadTasks";
            this.buttonUploadTasks.Size = new System.Drawing.Size(96, 32);
            this.buttonUploadTasks.TabIndex = 1;
            this.buttonUploadTasks.Text = "Upload        tasks";
            this.buttonUploadTasks.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonUploadTasks.Click += new System.EventHandler(this.OnUploadTasks);
            // 
            // buttonDownloadTasks
            // 
            this.buttonDownloadTasks.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonDownloadTasks.ImageIndex = 3;
            this.buttonDownloadTasks.ImageList = this.imageListTransfer;
            this.buttonDownloadTasks.Location = new System.Drawing.Point(8, 8);
            this.buttonDownloadTasks.Name = "buttonDownloadTasks";
            this.buttonDownloadTasks.Size = new System.Drawing.Size(96, 32);
            this.buttonDownloadTasks.TabIndex = 0;
            this.buttonDownloadTasks.Text = "Download   tasks";
            this.buttonDownloadTasks.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonDownloadTasks.Click += new System.EventHandler(this.OnDownloadTasks);
            // 
            // panelWaypoints
            // 
            this.panelWaypoints.BackColor = System.Drawing.Color.Transparent;
            this.panelWaypoints.Controls.Add(this.visibleCatalogueItems);
            this.panelWaypoints.Controls.Add(this.label15);
            this.panelWaypoints.Controls.Add(this.catalogueItems);
            this.panelWaypoints.Controls.Add(this.label6);
            this.panelWaypoints.Controls.Add(this.label5);
            this.panelWaypoints.Controls.Add(this.comboBoxCatalogues);
            this.panelWaypoints.Controls.Add(this.panel3);
            this.panelWaypoints.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelWaypoints.DockPadding.All = 5;
            this.panelWaypoints.Location = new System.Drawing.Point(95, 5);
            this.panelWaypoints.Name = "panelWaypoints";
            this.panelWaypoints.Size = new System.Drawing.Size(828, 608);
            this.panelWaypoints.TabIndex = 4;
            // 
            // visibleCatalogueItems
            // 
            this.visibleCatalogueItems.BackColor = System.Drawing.SystemColors.Window;
            this.visibleCatalogueItems.ForeColor = System.Drawing.Color.Red;
            this.visibleCatalogueItems.Location = new System.Drawing.Point(232, 80);
            this.visibleCatalogueItems.Name = "visibleCatalogueItems";
            this.visibleCatalogueItems.Size = new System.Drawing.Size(64, 20);
            this.visibleCatalogueItems.TabIndex = 7;
            this.visibleCatalogueItems.Text = "";
            this.visibleCatalogueItems.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // label15
            // 
            this.label15.AutoSize = true;
            this.label15.Location = new System.Drawing.Point(232, 64);
            this.label15.Name = "label15";
            this.label15.Size = new System.Drawing.Size(90, 16);
            this.label15.TabIndex = 6;
            this.label15.Text = "Items for transfer";
            // 
            // catalogueItems
            // 
            this.catalogueItems.Location = new System.Drawing.Point(232, 32);
            this.catalogueItems.Name = "catalogueItems";
            this.catalogueItems.Size = new System.Drawing.Size(64, 20);
            this.catalogueItems.TabIndex = 5;
            this.catalogueItems.Text = "";
            this.catalogueItems.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // label6
            // 
            this.label6.AutoSize = true;
            this.label6.Location = new System.Drawing.Point(232, 16);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(96, 16);
            this.label6.TabIndex = 4;
            this.label6.Text = "Items in catalogue";
            // 
            // label5
            // 
            this.label5.AutoSize = true;
            this.label5.Location = new System.Drawing.Point(16, 16);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(56, 16);
            this.label5.TabIndex = 3;
            this.label5.Text = "Catalogue";
            // 
            // comboBoxCatalogues
            // 
            this.comboBoxCatalogues.Location = new System.Drawing.Point(16, 32);
            this.comboBoxCatalogues.Name = "comboBoxCatalogues";
            this.comboBoxCatalogues.Size = new System.Drawing.Size(184, 21);
            this.comboBoxCatalogues.TabIndex = 2;
            this.comboBoxCatalogues.SelectedIndexChanged += new System.EventHandler(this.OnCatalogueChanged);
            // 
            // panel3
            // 
            this.panel3.BackColor = System.Drawing.Color.Transparent;
            this.panel3.Controls.Add(this.buttonUploadWaypoints);
            this.panel3.Controls.Add(this.buttonDownloadWaypoints);
            this.panel3.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel3.Location = new System.Drawing.Point(5, 555);
            this.panel3.Name = "panel3";
            this.panel3.Size = new System.Drawing.Size(818, 48);
            this.panel3.TabIndex = 1;
            // 
            // buttonUploadWaypoints
            // 
            this.buttonUploadWaypoints.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonUploadWaypoints.ImageIndex = 2;
            this.buttonUploadWaypoints.ImageList = this.imageListTransfer;
            this.buttonUploadWaypoints.Location = new System.Drawing.Point(112, 8);
            this.buttonUploadWaypoints.Name = "buttonUploadWaypoints";
            this.buttonUploadWaypoints.Size = new System.Drawing.Size(96, 32);
            this.buttonUploadWaypoints.TabIndex = 1;
            this.buttonUploadWaypoints.Text = "Upload Waypoints";
            this.buttonUploadWaypoints.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonUploadWaypoints.Click += new System.EventHandler(this.OnUploadWaypoints);
            // 
            // buttonDownloadWaypoints
            // 
            this.buttonDownloadWaypoints.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonDownloadWaypoints.ImageIndex = 3;
            this.buttonDownloadWaypoints.ImageList = this.imageListTransfer;
            this.buttonDownloadWaypoints.Location = new System.Drawing.Point(8, 8);
            this.buttonDownloadWaypoints.Name = "buttonDownloadWaypoints";
            this.buttonDownloadWaypoints.Size = new System.Drawing.Size(96, 32);
            this.buttonDownloadWaypoints.TabIndex = 0;
            this.buttonDownloadWaypoints.Text = "Download waypoints";
            this.buttonDownloadWaypoints.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonDownloadWaypoints.Click += new System.EventHandler(this.OnDownloadWaypoints);
            // 
            // panelDeclaration
            // 
            this.panelDeclaration.BackColor = System.Drawing.Color.Transparent;
            this.panelDeclaration.Controls.Add(this.panel4);
            this.panelDeclaration.Controls.Add(this.labelTaskType);
            this.panelDeclaration.Controls.Add(this.buttonSelectPilot2);
            this.panelDeclaration.Controls.Add(this.buttonSelectPilot1);
            this.panelDeclaration.Controls.Add(this.textBoxCompId);
            this.panelDeclaration.Controls.Add(this.label13);
            this.panelDeclaration.Controls.Add(this.textBoxGliderId);
            this.panelDeclaration.Controls.Add(this.comboBoxCompClass);
            this.panelDeclaration.Controls.Add(this.label12);
            this.panelDeclaration.Controls.Add(this.label11);
            this.panelDeclaration.Controls.Add(this.comboBoxGlider);
            this.panelDeclaration.Controls.Add(this.label10);
            this.panelDeclaration.Controls.Add(this.label9);
            this.panelDeclaration.Controls.Add(this.textPilot2);
            this.panelDeclaration.Controls.Add(this.textPilot1);
            this.panelDeclaration.Controls.Add(this.label8);
            this.panelDeclaration.Controls.Add(this.listViewTask);
            this.panelDeclaration.Controls.Add(this.comboBoxTask);
            this.panelDeclaration.Controls.Add(this.label7);
            this.panelDeclaration.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelDeclaration.DockPadding.All = 5;
            this.panelDeclaration.Location = new System.Drawing.Point(95, 5);
            this.panelDeclaration.Name = "panelDeclaration";
            this.panelDeclaration.Size = new System.Drawing.Size(828, 608);
            this.panelDeclaration.TabIndex = 5;
            // 
            // panel4
            // 
            this.panel4.BackColor = System.Drawing.Color.Transparent;
            this.panel4.Controls.Add(this.buttonUploadDeclaration);
            this.panel4.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel4.Location = new System.Drawing.Point(5, 555);
            this.panel4.Name = "panel4";
            this.panel4.Size = new System.Drawing.Size(818, 48);
            this.panel4.TabIndex = 2;
            // 
            // buttonUploadDeclaration
            // 
            this.buttonUploadDeclaration.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonUploadDeclaration.ImageIndex = 2;
            this.buttonUploadDeclaration.ImageList = this.imageListTransfer;
            this.buttonUploadDeclaration.Location = new System.Drawing.Point(8, 8);
            this.buttonUploadDeclaration.Name = "buttonUploadDeclaration";
            this.buttonUploadDeclaration.Size = new System.Drawing.Size(96, 32);
            this.buttonUploadDeclaration.TabIndex = 1;
            this.buttonUploadDeclaration.Text = "Upload Declaration";
            this.buttonUploadDeclaration.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonUploadDeclaration.Click += new System.EventHandler(this.OnUploadDeclaration);
            // 
            // labelTaskType
            // 
            this.labelTaskType.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.labelTaskType.ForeColor = System.Drawing.Color.OrangeRed;
            this.labelTaskType.Location = new System.Drawing.Point(224, 15);
            this.labelTaskType.Name = "labelTaskType";
            this.labelTaskType.Size = new System.Drawing.Size(256, 23);
            this.labelTaskType.TabIndex = 21;
            this.labelTaskType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // buttonSelectPilot2
            // 
            this.buttonSelectPilot2.Image = ((System.Drawing.Image)(resources.GetObject("buttonSelectPilot2.Image")));
            this.buttonSelectPilot2.Location = new System.Drawing.Point(480, 224);
            this.buttonSelectPilot2.Name = "buttonSelectPilot2";
            this.buttonSelectPilot2.Size = new System.Drawing.Size(22, 22);
            this.buttonSelectPilot2.TabIndex = 20;
            this.buttonSelectPilot2.Click += new System.EventHandler(this.OnSelectPilot2);
            // 
            // buttonSelectPilot1
            // 
            this.buttonSelectPilot1.Image = ((System.Drawing.Image)(resources.GetObject("buttonSelectPilot1.Image")));
            this.buttonSelectPilot1.Location = new System.Drawing.Point(232, 224);
            this.buttonSelectPilot1.Name = "buttonSelectPilot1";
            this.buttonSelectPilot1.Size = new System.Drawing.Size(22, 22);
            this.buttonSelectPilot1.TabIndex = 19;
            this.buttonSelectPilot1.Click += new System.EventHandler(this.OnSelectPilot1);
            // 
            // textBoxCompId
            // 
            this.textBoxCompId.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
            this.textBoxCompId.Location = new System.Drawing.Point(328, 288);
            this.textBoxCompId.Name = "textBoxCompId";
            this.textBoxCompId.Size = new System.Drawing.Size(32, 20);
            this.textBoxCompId.TabIndex = 18;
            this.textBoxCompId.Text = "";
            // 
            // label13
            // 
            this.label13.AutoSize = true;
            this.label13.Location = new System.Drawing.Point(269, 288);
            this.label13.Name = "label13";
            this.label13.Size = new System.Drawing.Size(52, 16);
            this.label13.TabIndex = 17;
            this.label13.Text = "Comp. ID";
            // 
            // textBoxGliderId
            // 
            this.textBoxGliderId.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
            this.textBoxGliderId.Location = new System.Drawing.Point(328, 256);
            this.textBoxGliderId.Name = "textBoxGliderId";
            this.textBoxGliderId.Size = new System.Drawing.Size(152, 20);
            this.textBoxGliderId.TabIndex = 16;
            this.textBoxGliderId.Text = "";
            // 
            // comboBoxCompClass
            // 
            this.comboBoxCompClass.Location = new System.Drawing.Point(80, 288);
            this.comboBoxCompClass.Name = "comboBoxCompClass";
            this.comboBoxCompClass.Size = new System.Drawing.Size(152, 21);
            this.comboBoxCompClass.Sorted = true;
            this.comboBoxCompClass.TabIndex = 15;
            // 
            // label12
            // 
            this.label12.AutoSize = true;
            this.label12.Location = new System.Drawing.Point(8, 288);
            this.label12.Name = "label12";
            this.label12.Size = new System.Drawing.Size(69, 16);
            this.label12.TabIndex = 14;
            this.label12.Text = "Comp. Class";
            // 
            // label11
            // 
            this.label11.AutoSize = true;
            this.label11.Location = new System.Drawing.Point(272, 256);
            this.label11.Name = "label11";
            this.label11.Size = new System.Drawing.Size(49, 16);
            this.label11.TabIndex = 12;
            this.label11.Text = "Glider ID";
            // 
            // comboBoxGlider
            // 
            this.comboBoxGlider.Location = new System.Drawing.Point(80, 256);
            this.comboBoxGlider.Name = "comboBoxGlider";
            this.comboBoxGlider.Size = new System.Drawing.Size(152, 21);
            this.comboBoxGlider.Sorted = true;
            this.comboBoxGlider.TabIndex = 11;
            // 
            // label10
            // 
            this.label10.AutoSize = true;
            this.label10.Location = new System.Drawing.Point(40, 256);
            this.label10.Name = "label10";
            this.label10.Size = new System.Drawing.Size(35, 16);
            this.label10.TabIndex = 10;
            this.label10.Text = "Glider";
            // 
            // label9
            // 
            this.label9.AutoSize = true;
            this.label9.Location = new System.Drawing.Point(288, 224);
            this.label9.Name = "label9";
            this.label9.Size = new System.Drawing.Size(36, 16);
            this.label9.TabIndex = 9;
            this.label9.Text = "Pilot 2";
            // 
            // textPilot2
            // 
            this.textPilot2.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
            this.textPilot2.Location = new System.Drawing.Point(328, 224);
            this.textPilot2.Name = "textPilot2";
            this.textPilot2.Size = new System.Drawing.Size(152, 20);
            this.textPilot2.TabIndex = 8;
            this.textPilot2.Text = "";
            // 
            // textPilot1
            // 
            this.textPilot1.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
            this.textPilot1.Location = new System.Drawing.Point(80, 224);
            this.textPilot1.Name = "textPilot1";
            this.textPilot1.Size = new System.Drawing.Size(152, 20);
            this.textPilot1.TabIndex = 7;
            this.textPilot1.Text = "";
            // 
            // label8
            // 
            this.label8.AutoSize = true;
            this.label8.Location = new System.Drawing.Point(40, 224);
            this.label8.Name = "label8";
            this.label8.Size = new System.Drawing.Size(36, 16);
            this.label8.TabIndex = 6;
            this.label8.Text = "Pilot 1";
            // 
            // listViewTask
            // 
            this.listViewTask.BackColor = System.Drawing.SystemColors.Window;
            this.listViewTask.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
                                                                                           this.columnType,
                                                                                           this.columnName,
                                                                                           this.columnLat,
                                                                                           this.columnLongitude});
            this.listViewTask.FullRowSelect = true;
            this.listViewTask.GridLines = true;
            this.listViewTask.Location = new System.Drawing.Point(80, 48);
            this.listViewTask.Name = "listViewTask";
            this.listViewTask.Size = new System.Drawing.Size(400, 168);
            this.listViewTask.TabIndex = 5;
            this.listViewTask.View = System.Windows.Forms.View.Details;
            // 
            // columnType
            // 
            this.columnType.Text = "Type";
            this.columnType.Width = 80;
            // 
            // columnName
            // 
            this.columnName.Text = "Name";
            this.columnName.Width = 140;
            // 
            // columnLat
            // 
            this.columnLat.Text = "Latitude";
            this.columnLat.Width = 80;
            // 
            // columnLongitude
            // 
            this.columnLongitude.Text = "Longitude";
            this.columnLongitude.Width = 80;
            // 
            // comboBoxTask
            // 
            this.comboBoxTask.Location = new System.Drawing.Point(80, 16);
            this.comboBoxTask.Name = "comboBoxTask";
            this.comboBoxTask.Size = new System.Drawing.Size(136, 21);
            this.comboBoxTask.TabIndex = 4;
            this.comboBoxTask.SelectedIndexChanged += new System.EventHandler(this.OnSelectedTaskChanged);
            // 
            // label7
            // 
            this.label7.AutoSize = true;
            this.label7.Location = new System.Drawing.Point(48, 18);
            this.label7.Name = "label7";
            this.label7.Size = new System.Drawing.Size(29, 16);
            this.label7.TabIndex = 3;
            this.label7.Text = "Task";
            // 
            // panelInfo
            // 
            this.panelInfo.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.panelInfo.Controls.Add(this.progress);
            this.panelInfo.Controls.Add(this.buttonCancelTransfer);
            this.panelInfo.Controls.Add(this.connectionStatusPictureBox);
            this.panelInfo.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panelInfo.DockPadding.All = 2;
            this.panelInfo.Location = new System.Drawing.Point(95, 613);
            this.panelInfo.Name = "panelInfo";
            this.panelInfo.Size = new System.Drawing.Size(828, 38);
            this.panelInfo.TabIndex = 6;
            // 
            // progress
            // 
            this.progress.Dock = System.Windows.Forms.DockStyle.Fill;
            this.progress.Location = new System.Drawing.Point(77, 2);
            this.progress.Maximum = 1000;
            this.progress.Name = "progress";
            this.progress.Size = new System.Drawing.Size(715, 32);
            this.progress.Step = 1;
            this.progress.TabIndex = 3;
            // 
            // buttonCancelTransfer
            // 
            this.buttonCancelTransfer.Dock = System.Windows.Forms.DockStyle.Left;
            this.buttonCancelTransfer.Location = new System.Drawing.Point(2, 2);
            this.buttonCancelTransfer.Name = "buttonCancelTransfer";
            this.buttonCancelTransfer.Size = new System.Drawing.Size(75, 32);
            this.buttonCancelTransfer.TabIndex = 2;
            this.buttonCancelTransfer.Text = "Cancel";
            this.buttonCancelTransfer.Click += new System.EventHandler(this.OnClickCancelTransfer);
            // 
            // connectionStatusPictureBox
            // 
            this.connectionStatusPictureBox.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.connectionStatusPictureBox.Dock = System.Windows.Forms.DockStyle.Right;
            this.connectionStatusPictureBox.Location = new System.Drawing.Point(792, 2);
            this.connectionStatusPictureBox.Name = "connectionStatusPictureBox";
            this.connectionStatusPictureBox.Size = new System.Drawing.Size(32, 32);
            this.connectionStatusPictureBox.SizeMode = System.Windows.Forms.PictureBoxSizeMode.CenterImage;
            this.connectionStatusPictureBox.TabIndex = 0;
            this.connectionStatusPictureBox.TabStop = false;
            // 
            // imageListConnectionStatus
            // 
            this.imageListConnectionStatus.ImageSize = new System.Drawing.Size(32, 32);
            this.imageListConnectionStatus.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListConnectionStatus.ImageStream")));
            this.imageListConnectionStatus.TransparentColor = System.Drawing.Color.Transparent;
            // 
            // panelSUA
            // 
            this.panelSUA.BackColor = System.Drawing.Color.Transparent;
            this.panelSUA.Controls.Add(this.panelSUABottom);
            this.panelSUA.Controls.Add(this.panelSUATop);
            this.panelSUA.Controls.Add(this.panel6);
            this.panelSUA.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelSUA.DockPadding.All = 5;
            this.panelSUA.Location = new System.Drawing.Point(95, 5);
            this.panelSUA.Name = "panelSUA";
            this.panelSUA.Size = new System.Drawing.Size(828, 608);
            this.panelSUA.TabIndex = 7;
            this.panelSUA.VisibleChanged += new System.EventHandler(this.OnSUAVisibleChanged);
            // 
            // panelSUABottom
            // 
            this.panelSUABottom.Controls.Add(this.listViewSUAs);
            this.panelSUABottom.Controls.Add(this.labelSUAItems);
            this.panelSUABottom.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelSUABottom.Location = new System.Drawing.Point(5, 261);
            this.panelSUABottom.Name = "panelSUABottom";
            this.panelSUABottom.Size = new System.Drawing.Size(818, 294);
            this.panelSUABottom.TabIndex = 11;
            // 
            // listViewSUAs
            // 
            this.listViewSUAs.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
                                                                                           this.columnSUAName,
                                                                                           this.columnSUAId,
                                                                                           this.columnSUAClass,
                                                                                           this.columnSUAType,
                                                                                           this.columnSUABase,
                                                                                           this.columnSUATop,
                                                                                           this.columnSUAComm,
                                                                                           this.columnSUAFrequency,
                                                                                           this.columnSUARemark});
            this.listViewSUAs.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listViewSUAs.FullRowSelect = true;
            this.listViewSUAs.GridLines = true;
            this.listViewSUAs.HideSelection = false;
            this.listViewSUAs.Location = new System.Drawing.Point(0, 0);
            this.listViewSUAs.Name = "listViewSUAs";
            this.listViewSUAs.Size = new System.Drawing.Size(818, 271);
            this.listViewSUAs.Sorting = System.Windows.Forms.SortOrder.Ascending;
            this.listViewSUAs.TabIndex = 6;
            this.listViewSUAs.View = System.Windows.Forms.View.Details;
            this.listViewSUAs.KeyDown += new System.Windows.Forms.KeyEventHandler(this.OnKeyDownSUAs);
            this.listViewSUAs.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.OnColumnClick);
            // 
            // columnSUAName
            // 
            this.columnSUAName.Text = "Name";
            this.columnSUAName.Width = 150;
            // 
            // columnSUAId
            // 
            this.columnSUAId.Text = "ID";
            // 
            // columnSUAClass
            // 
            this.columnSUAClass.Text = "Class";
            // 
            // columnSUAType
            // 
            this.columnSUAType.Text = "Type";
            this.columnSUAType.Width = 80;
            // 
            // columnSUABase
            // 
            this.columnSUABase.Text = "Base";
            this.columnSUABase.Width = 80;
            // 
            // columnSUATop
            // 
            this.columnSUATop.Text = "Top";
            this.columnSUATop.Width = 80;
            // 
            // columnSUAComm
            // 
            this.columnSUAComm.Text = "Comm. Name";
            this.columnSUAComm.Width = 78;
            // 
            // columnSUAFrequency
            // 
            this.columnSUAFrequency.Text = "Frequency";
            this.columnSUAFrequency.Width = 64;
            // 
            // columnSUARemark
            // 
            this.columnSUARemark.Text = "Remark";
            this.columnSUARemark.Width = 220;
            // 
            // labelSUAItems
            // 
            this.labelSUAItems.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.labelSUAItems.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.labelSUAItems.ForeColor = System.Drawing.Color.Red;
            this.labelSUAItems.Location = new System.Drawing.Point(0, 271);
            this.labelSUAItems.Name = "labelSUAItems";
            this.labelSUAItems.Size = new System.Drawing.Size(818, 23);
            this.labelSUAItems.TabIndex = 10;
            this.labelSUAItems.Text = "0 items";
            this.labelSUAItems.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // panelSUATop
            // 
            this.panelSUATop.Controls.Add(this.groupBox2);
            this.panelSUATop.Controls.Add(this.buttonUseAllCountries);
            this.panelSUATop.Controls.Add(this.groupBox1);
            this.panelSUATop.Controls.Add(this.groupBoxArea);
            this.panelSUATop.Controls.Add(this.radioButtonArea);
            this.panelSUATop.Controls.Add(this.checkedListBoxCountry);
            this.panelSUATop.Controls.Add(this.radioButtonCountry);
            this.panelSUATop.Dock = System.Windows.Forms.DockStyle.Top;
            this.panelSUATop.Location = new System.Drawing.Point(5, 5);
            this.panelSUATop.Name = "panelSUATop";
            this.panelSUATop.Size = new System.Drawing.Size(818, 256);
            this.panelSUATop.TabIndex = 9;
            // 
            // groupBox2
            // 
            this.groupBox2.Controls.Add(this.checkedListBoxClasses);
            this.groupBox2.Controls.Add(this.buttonUseAllClasses);
            this.groupBox2.Location = new System.Drawing.Point(560, 8);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(152, 240);
            this.groupBox2.TabIndex = 9;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "Classes (contr. airspace)";
            // 
            // checkedListBoxClasses
            // 
            this.checkedListBoxClasses.CheckOnClick = true;
            this.checkedListBoxClasses.Location = new System.Drawing.Point(8, 56);
            this.checkedListBoxClasses.Name = "checkedListBoxClasses";
            this.checkedListBoxClasses.ScrollAlwaysVisible = true;
            this.checkedListBoxClasses.Size = new System.Drawing.Size(136, 169);
            this.checkedListBoxClasses.Sorted = true;
            this.checkedListBoxClasses.TabIndex = 10;
            this.checkedListBoxClasses.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.OnItemCheckChangedClasses);
            // 
            // buttonUseAllClasses
            // 
            this.buttonUseAllClasses.Location = new System.Drawing.Point(8, 24);
            this.buttonUseAllClasses.Name = "buttonUseAllClasses";
            this.buttonUseAllClasses.Size = new System.Drawing.Size(75, 24);
            this.buttonUseAllClasses.TabIndex = 9;
            this.buttonUseAllClasses.Text = "Select all";
            this.buttonUseAllClasses.Click += new System.EventHandler(this.OnUseAllClasses);
            // 
            // buttonUseAllCountries
            // 
            this.buttonUseAllCountries.Location = new System.Drawing.Point(8, 40);
            this.buttonUseAllCountries.Name = "buttonUseAllCountries";
            this.buttonUseAllCountries.Size = new System.Drawing.Size(75, 24);
            this.buttonUseAllCountries.TabIndex = 8;
            this.buttonUseAllCountries.Text = "Select all";
            this.buttonUseAllCountries.Click += new System.EventHandler(this.OnUseAllCountries);
            // 
            // groupBox1
            // 
            this.groupBox1.Controls.Add(this.checkedListBoxAirspaces);
            this.groupBox1.Controls.Add(this.buttonUseAllAirspaces);
            this.groupBox1.Location = new System.Drawing.Point(392, 8);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(152, 240);
            this.groupBox1.TabIndex = 7;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "Airspaces";
            // 
            // checkedListBoxAirspaces
            // 
            this.checkedListBoxAirspaces.CheckOnClick = true;
            this.checkedListBoxAirspaces.Location = new System.Drawing.Point(8, 56);
            this.checkedListBoxAirspaces.Name = "checkedListBoxAirspaces";
            this.checkedListBoxAirspaces.ScrollAlwaysVisible = true;
            this.checkedListBoxAirspaces.Size = new System.Drawing.Size(136, 169);
            this.checkedListBoxAirspaces.Sorted = true;
            this.checkedListBoxAirspaces.TabIndex = 10;
            this.checkedListBoxAirspaces.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.OnItemCheckChangedSUA);
            // 
            // buttonUseAllAirspaces
            // 
            this.buttonUseAllAirspaces.Location = new System.Drawing.Point(8, 24);
            this.buttonUseAllAirspaces.Name = "buttonUseAllAirspaces";
            this.buttonUseAllAirspaces.Size = new System.Drawing.Size(75, 24);
            this.buttonUseAllAirspaces.TabIndex = 9;
            this.buttonUseAllAirspaces.Text = "Select all";
            this.buttonUseAllAirspaces.Click += new System.EventHandler(this.OnUseAllAirspaces);
            // 
            // groupBoxArea
            // 
            this.groupBoxArea.Controls.Add(this.checkBoxUseMapCoord);
            this.groupBoxArea.Controls.Add(this.coordEditControlLonTo);
            this.groupBoxArea.Controls.Add(this.coordEditControlLatTo);
            this.groupBoxArea.Controls.Add(this.label16);
            this.groupBoxArea.Controls.Add(this.coordEditControlLonFrom);
            this.groupBoxArea.Controls.Add(this.coordEditControlLatFrom);
            this.groupBoxArea.Controls.Add(this.label17);
            this.groupBoxArea.Location = new System.Drawing.Point(168, 40);
            this.groupBoxArea.Name = "groupBoxArea";
            this.groupBoxArea.Size = new System.Drawing.Size(208, 120);
            this.groupBoxArea.TabIndex = 5;
            this.groupBoxArea.TabStop = false;
            this.groupBoxArea.Text = "Area";
            // 
            // checkBoxUseMapCoord
            // 
            this.checkBoxUseMapCoord.Location = new System.Drawing.Point(40, 88);
            this.checkBoxUseMapCoord.Name = "checkBoxUseMapCoord";
            this.checkBoxUseMapCoord.TabIndex = 6;
            this.checkBoxUseMapCoord.Text = "use map area";
            this.checkBoxUseMapCoord.CheckedChanged += new System.EventHandler(this.OnUseMapArea);
            // 
            // coordEditControlLonTo
            // 
            this.coordEditControlLonTo.BackColor = System.Drawing.SystemColors.Control;
            this.coordEditControlLonTo.IsLatitude = false;
            this.coordEditControlLonTo.Location = new System.Drawing.Point(120, 56);
            this.coordEditControlLonTo.Name = "coordEditControlLonTo";
            this.coordEditControlLonTo.Size = new System.Drawing.Size(72, 24);
            this.coordEditControlLonTo.TabIndex = 5;
            this.coordEditControlLonTo.Value = 0;
            this.coordEditControlLonTo.Leave += new System.EventHandler(this.OnChangeArea);
            // 
            // coordEditControlLatTo
            // 
            this.coordEditControlLatTo.BackColor = System.Drawing.SystemColors.Control;
            this.coordEditControlLatTo.IsLatitude = true;
            this.coordEditControlLatTo.Location = new System.Drawing.Point(40, 56);
            this.coordEditControlLatTo.Name = "coordEditControlLatTo";
            this.coordEditControlLatTo.Size = new System.Drawing.Size(72, 24);
            this.coordEditControlLatTo.TabIndex = 4;
            this.coordEditControlLatTo.Value = 0;
            this.coordEditControlLatTo.Leave += new System.EventHandler(this.OnChangeArea);
            // 
            // label16
            // 
            this.label16.AutoSize = true;
            this.label16.Location = new System.Drawing.Point(24, 56);
            this.label16.Name = "label16";
            this.label16.Size = new System.Drawing.Size(14, 16);
            this.label16.TabIndex = 3;
            this.label16.Text = "to";
            // 
            // coordEditControlLonFrom
            // 
            this.coordEditControlLonFrom.BackColor = System.Drawing.SystemColors.Control;
            this.coordEditControlLonFrom.IsLatitude = false;
            this.coordEditControlLonFrom.Location = new System.Drawing.Point(120, 24);
            this.coordEditControlLonFrom.Name = "coordEditControlLonFrom";
            this.coordEditControlLonFrom.Size = new System.Drawing.Size(72, 24);
            this.coordEditControlLonFrom.TabIndex = 2;
            this.coordEditControlLonFrom.Value = 0;
            this.coordEditControlLonFrom.Leave += new System.EventHandler(this.OnChangeArea);
            // 
            // coordEditControlLatFrom
            // 
            this.coordEditControlLatFrom.BackColor = System.Drawing.SystemColors.Control;
            this.coordEditControlLatFrom.IsLatitude = true;
            this.coordEditControlLatFrom.Location = new System.Drawing.Point(40, 24);
            this.coordEditControlLatFrom.Name = "coordEditControlLatFrom";
            this.coordEditControlLatFrom.Size = new System.Drawing.Size(72, 24);
            this.coordEditControlLatFrom.TabIndex = 1;
            this.coordEditControlLatFrom.Value = 0;
            this.coordEditControlLatFrom.Leave += new System.EventHandler(this.OnChangeArea);
            // 
            // label17
            // 
            this.label17.AutoSize = true;
            this.label17.Location = new System.Drawing.Point(8, 24);
            this.label17.Name = "label17";
            this.label17.Size = new System.Drawing.Size(27, 16);
            this.label17.TabIndex = 0;
            this.label17.Text = "from";
            // 
            // radioButtonArea
            // 
            this.radioButtonArea.Location = new System.Drawing.Point(168, 8);
            this.radioButtonArea.Name = "radioButtonArea";
            this.radioButtonArea.TabIndex = 4;
            this.radioButtonArea.Text = "Select by area";
            this.radioButtonArea.CheckedChanged += new System.EventHandler(this.OnSelectedAreaChanged);
            // 
            // checkedListBoxCountry
            // 
            this.checkedListBoxCountry.CheckOnClick = true;
            this.checkedListBoxCountry.Location = new System.Drawing.Point(8, 72);
            this.checkedListBoxCountry.Name = "checkedListBoxCountry";
            this.checkedListBoxCountry.ScrollAlwaysVisible = true;
            this.checkedListBoxCountry.Size = new System.Drawing.Size(144, 169);
            this.checkedListBoxCountry.Sorted = true;
            this.checkedListBoxCountry.TabIndex = 3;
            this.checkedListBoxCountry.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.OnItemCheckChanged);
            // 
            // radioButtonCountry
            // 
            this.radioButtonCountry.Location = new System.Drawing.Point(8, 8);
            this.radioButtonCountry.Name = "radioButtonCountry";
            this.radioButtonCountry.Size = new System.Drawing.Size(144, 24);
            this.radioButtonCountry.TabIndex = 1;
            this.radioButtonCountry.Text = "Select by country";
            this.radioButtonCountry.CheckedChanged += new System.EventHandler(this.OnSelectedAreaChanged);
            // 
            // panel6
            // 
            this.panel6.Controls.Add(this.buttonUploadSUA);
            this.panel6.Controls.Add(this.label19);
            this.panel6.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel6.Location = new System.Drawing.Point(5, 555);
            this.panel6.Name = "panel6";
            this.panel6.Size = new System.Drawing.Size(818, 48);
            this.panel6.TabIndex = 0;
            // 
            // buttonUploadSUA
            // 
            this.buttonUploadSUA.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonUploadSUA.ImageIndex = 2;
            this.buttonUploadSUA.ImageList = this.imageListTransfer;
            this.buttonUploadSUA.Location = new System.Drawing.Point(8, 8);
            this.buttonUploadSUA.Name = "buttonUploadSUA";
            this.buttonUploadSUA.Size = new System.Drawing.Size(96, 32);
            this.buttonUploadSUA.TabIndex = 1;
            this.buttonUploadSUA.Text = "Upload        SUA\'s";
            this.buttonUploadSUA.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonUploadSUA.Click += new System.EventHandler(this.OnUploadSUA);
            // 
            // label19
            // 
            this.label19.Location = new System.Drawing.Point(24, -24);
            this.label19.Name = "label19";
            this.label19.TabIndex = 10;
            this.label19.Text = "label18";
            // 
            // panelPilots
            // 
            this.panelPilots.Controls.Add(this.panel8);
            this.panelPilots.Controls.Add(this.panel7);
            this.panelPilots.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelPilots.Location = new System.Drawing.Point(95, 5);
            this.panelPilots.Name = "panelPilots";
            this.panelPilots.Size = new System.Drawing.Size(828, 608);
            this.panelPilots.TabIndex = 8;
            // 
            // panel8
            // 
            this.panel8.Controls.Add(this.listBoxPilots);
            this.panel8.Controls.Add(this.panel9);
            this.panel8.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panel8.Location = new System.Drawing.Point(0, 0);
            this.panel8.Name = "panel8";
            this.panel8.Size = new System.Drawing.Size(828, 560);
            this.panel8.TabIndex = 2;
            // 
            // listBoxPilots
            // 
            this.listBoxPilots.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listBoxPilots.Location = new System.Drawing.Point(0, 0);
            this.listBoxPilots.Name = "listBoxPilots";
            this.listBoxPilots.ScrollAlwaysVisible = true;
            this.listBoxPilots.SelectionMode = System.Windows.Forms.SelectionMode.MultiExtended;
            this.listBoxPilots.Size = new System.Drawing.Size(828, 511);
            this.listBoxPilots.Sorted = true;
            this.listBoxPilots.TabIndex = 0;
            this.listBoxPilots.KeyDown += new System.Windows.Forms.KeyEventHandler(this.OnKeyDownPilots);
            // 
            // panel9
            // 
            this.panel9.Controls.Add(this.button1);
            this.panel9.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel9.Location = new System.Drawing.Point(0, 512);
            this.panel9.Name = "panel9";
            this.panel9.Size = new System.Drawing.Size(828, 48);
            this.panel9.TabIndex = 4;
            // 
            // button1
            // 
            this.button1.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.button1.ImageIndex = 4;
            this.button1.ImageList = this.imageListTransfer;
            this.button1.Location = new System.Drawing.Point(8, 8);
            this.button1.Name = "button1";
            this.button1.Size = new System.Drawing.Size(96, 32);
            this.button1.TabIndex = 2;
            this.button1.Text = "Reload            Pilots";
            this.button1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.button1.Click += new System.EventHandler(this.OnReloadPilots);
            // 
            // panel7
            // 
            this.panel7.Controls.Add(this.buttonUploadPilots);
            this.panel7.Controls.Add(this.buttonDownloadPilots);
            this.panel7.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panel7.Location = new System.Drawing.Point(0, 560);
            this.panel7.Name = "panel7";
            this.panel7.Size = new System.Drawing.Size(828, 48);
            this.panel7.TabIndex = 1;
            // 
            // buttonUploadPilots
            // 
            this.buttonUploadPilots.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonUploadPilots.ImageIndex = 2;
            this.buttonUploadPilots.ImageList = this.imageListTransfer;
            this.buttonUploadPilots.Location = new System.Drawing.Point(112, 8);
            this.buttonUploadPilots.Name = "buttonUploadPilots";
            this.buttonUploadPilots.Size = new System.Drawing.Size(96, 32);
            this.buttonUploadPilots.TabIndex = 1;
            this.buttonUploadPilots.Text = "Upload        pilots";
            this.buttonUploadPilots.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonUploadPilots.Click += new System.EventHandler(this.OnUploadPilots);
            // 
            // buttonDownloadPilots
            // 
            this.buttonDownloadPilots.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonDownloadPilots.ImageIndex = 3;
            this.buttonDownloadPilots.ImageList = this.imageListTransfer;
            this.buttonDownloadPilots.Location = new System.Drawing.Point(8, 8);
            this.buttonDownloadPilots.Name = "buttonDownloadPilots";
            this.buttonDownloadPilots.Size = new System.Drawing.Size(96, 32);
            this.buttonDownloadPilots.TabIndex = 0;
            this.buttonDownloadPilots.Text = "Download   pilots";
            this.buttonDownloadPilots.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonDownloadPilots.Click += new System.EventHandler(this.OnDownloadPilots);
            // 
            // Recorder
            // 
            this.Controls.Add(this.panelSUA);
            this.Controls.Add(this.panelWaypoints);
            this.Controls.Add(this.panelTasks);
            this.Controls.Add(this.panelPilots);
            this.Controls.Add(this.panelFlight);
            this.Controls.Add(this.panelDeclaration);
            this.Controls.Add(this.panelConnection);
            this.Controls.Add(this.panelInfo);
            this.Controls.Add(this.optionsList);
            this.DockPadding.All = 5;
            this.Name = "Recorder";
            this.Size = new System.Drawing.Size(928, 656);
            this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.OnKeyDownSUAs);
            this.panelConnection.ResumeLayout(false);
            this.panelDescription.ResumeLayout(false);
            this.panelTop.ResumeLayout(false);
            this.panelFlight.ResumeLayout(false);
            this.panel1.ResumeLayout(false);
            this.groupBoxTransferOptions.ResumeLayout(false);
            this.panelTasks.ResumeLayout(false);
            this.panel5.ResumeLayout(false);
            this.panel2.ResumeLayout(false);
            this.panelWaypoints.ResumeLayout(false);
            this.panel3.ResumeLayout(false);
            this.panelDeclaration.ResumeLayout(false);
            this.panel4.ResumeLayout(false);
            this.panelInfo.ResumeLayout(false);
            this.panelSUA.ResumeLayout(false);
            this.panelSUABottom.ResumeLayout(false);
            this.panelSUATop.ResumeLayout(false);
            this.groupBox2.ResumeLayout(false);
            this.groupBox1.ResumeLayout(false);
            this.groupBoxArea.ResumeLayout(false);
            this.panel6.ResumeLayout(false);
            this.panelPilots.ResumeLayout(false);
            this.panel8.ResumeLayout(false);
            this.panel9.ResumeLayout(false);
            this.panel7.ResumeLayout(false);
            this.ResumeLayout(false);

        }

        private void OnSelectedItemChanged(object sender, System.EventArgs e) {
            if (optionsList.SelectedItems.Count > 0) {
                ListViewItem selectedItem = optionsList.SelectedItems[0];
                int i;
                for(i = 0; i < listViewItems.Length; i++) {
                    panels[i].Visible = (listViewItems[i] == selectedItem);
                }

                if (selectedItem == listViewItemDeclaration && currentRecorder != null) {
                    Regex split = new Regex("[ \t]+");
                    string []tokens = split.Split(currentRecorder.flightDeclaration.pilot);

                    if (tokens.Length > 0) {
                        textPilot1.Text = tokens[0];
                    }
                    if (tokens.Length > 1) {
                        textPilot1.Text += " " + tokens[1];
                    }
                    if (tokens.Length > 2) {
                        textPilot2.Text = tokens[2];
                    }
                    if (tokens.Length > 3) {
                        textPilot2.Text += " " + tokens[3];
                    }

                    textBoxCompId.Text = currentRecorder.flightDeclaration.competitionId;
                    textBoxGliderId.Text = currentRecorder.flightDeclaration.gliderId;
                    
                    string s = currentRecorder.flightDeclaration.gliderType.Replace(" ", "");
                    if (AppContents.gliderIndexes.ContainsKey(s)) {
                        comboBoxGlider.SelectedItem = AppContents.gliderIndexes[s];
                    }

                    if (currentRecorder.flightDeclaration.competitionClass != "" &&
                        (i = comboBoxCompClass.FindString(currentRecorder.flightDeclaration.competitionClass)) != -1) {
                        comboBoxCompClass.SelectedIndex = i;
                    }
                }
            }
        }

        private void OnRecorderChanged(object sender, System.EventArgs e) {
            Disconnect();
            comboBoxBaud.Items.Clear();
            comboBoxBaud.SelectedText = "";
            textBoxDescription.Text = "";
            if ((currentRecorder = (RecorderBase)comboManufacturer.SelectedItem) != null) {
                switch (currentRecorder.ConnectionType) {
                case RecorderConnectionType.Serial:
                    comboBoxBaud.Items.AddRange(((SerialConnectionRecorder)currentRecorder).SupportedLineSpeeds);
                    comboBoxBaud.SelectedItem = ((SerialConnectionRecorder)currentRecorder).PreferedSpeed;
                    textBoxDescription.Text = currentRecorder.Description;
                    comboBoxBaud.Enabled = true;
                    comboBoxPort.Enabled = true;
                    checkBoxRedirectToFile.Enabled = (currentRecorder.Options & RecorderOptions.ExportToFile) != 0;                        
                    checkBoxRedirectToFile.Checked = currentRecorder.RedirectToFile;
                    if (currentRecorder.RedirectToFile) {
                        comboBoxBaud.Enabled = false;
                        comboBoxPort.Enabled = false;
                        OnConnectRecorder(null, null);
                    }
                    break;
                }
            }
        }

        private void OnReadFlightDirectory(object sender, System.EventArgs e) {
            if (currentRecorder != null) {
                currentRecorder.flightDirectory.Clear();
                workerThread = currentRecorder.FlightDirectoryThread();
                RunThread();
            }
        }

        private void OnDownloadWaypoints(object sender, System.EventArgs e) {
            if (currentRecorder != null) {
                workerThread = currentRecorder.DownloadWaypointsThread();
                RunThread();
            }
        }

        private void OnUploadWaypoints(object sender, System.EventArgs e) {
            if (currentRecorder != null) {
                currentRecorder.currentCatalogue = (WaypointCatalog)comboBoxCatalogues.SelectedItem;
                if (currentRecorder.capacity.maxNrWaypoints != (int)CapacityNumbers.Unlimited && currentRecorder.currentCatalogue.VisibleWaypointsCount > currentRecorder.capacity.maxNrWaypoints) {
                    if (MessageBox.Show(this, string.Format("Too many waypoints ({0}) in catalogue {1}. The max. capacity is {2}.\nIf you proceed, all further waypoints will be ignored!\n\nProceed anyway?", 
                        currentRecorder.currentCatalogue.Count, currentRecorder.currentCatalogue.Name, currentRecorder.capacity.maxNrWaypoints), "Capacity exeeded", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2) == DialogResult.No) {
                        return;
                    }
                }
                workerThread = currentRecorder.UploadWaypointsThread();
                RunThread();
            }
        }

        private void OnUploadDeclaration(object sender, System.EventArgs e) {
            Task t = (Task)comboBoxTask.SelectedItem;

            if (currentRecorder != null && t != null) {
                currentRecorder.flightDeclaration.competitionClass = comboBoxCompClass.Text;
                currentRecorder.flightDeclaration.competitionId = textBoxCompId.Text;
                currentRecorder.flightDeclaration.gliderId = textBoxGliderId.Text;
                currentRecorder.flightDeclaration.gliderType = comboBoxGlider.Text;
                currentRecorder.flightDeclaration.pilot = textPilot1.Text + " " + textPilot2.Text;
                currentRecorder.declarationTask = t;

                // NOTE takeoff and landing are always ignored
                if (currentRecorder.capacity.maxNrWaypointsPerTask != (int)CapacityNumbers.Unlimited && t.Count - 2 > currentRecorder.capacity.maxNrWaypointsPerTask) {
                    if (MessageBox.Show(this, string.Format("Too many waypoints ({0}) in declaration form. The max. capacity is {1}.\nIf you proceed, all further waypoints in this task will be ignored!\n\nProceed anyway?", 
                        t.Count - 2, currentRecorder.capacity.maxNrWaypointsPerTask), "Capacity exeeded", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2) == DialogResult.No) {
                        return;
                    }
                }

                workerThread = currentRecorder.UploadDeclarationThread();
                RunThread();
            }
        }

        private void OnCatalogueChanged(object sender, System.EventArgs e) {
            WaypointCatalog c = (WaypointCatalog)comboBoxCatalogues.SelectedItem;
            if (c != null) {
                catalogueItems.Text = c.Count.ToString();
                visibleCatalogueItems.Text = c.VisibleWaypointsCount.ToString();
            }
            else {
                catalogueItems.Text = "";
                visibleCatalogueItems.Text = "";
            }
        }

        private void OnDownloadTasks(object sender, System.EventArgs e) {
            if (currentRecorder != null) {
                currentRecorder.tasks.Clear();
                workerThread = currentRecorder.DownloadTasksThread();
                RunThread();
            }
        }

        private void OnUploadTasks(object sender, System.EventArgs e) {
            if (currentRecorder != null) {
                currentRecorder.tasks.Clear();
                foreach (ListViewItem it in listViewTasks.Items) {
                    currentRecorder.tasks.Add(it.Tag);
                }

                if (currentRecorder.capacity.maxNrTasks != (int)CapacityNumbers.Unlimited && currentRecorder.tasks.Count > currentRecorder.capacity.maxNrTasks) {
                    if (MessageBox.Show(this, string.Format("Too many tasks ({0}) in list. The max. capacity is {1}.\nIf you proceed, all further tasks will be ignored!\n\nProceed anyway?", 
                        currentRecorder.tasks.Count, currentRecorder.capacity.maxNrTasks), "Capacity exeeded", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2) == DialogResult.No) {
                        return;
                    }
                }
                
                if (currentRecorder.capacity.maxNrWaypointsPerTask != (int)CapacityNumbers.Unlimited) {
                    foreach (Task t in currentRecorder.tasks) {
                        // NOTE takeoff and landing are always ignored
                        if (t.Count - 2 > currentRecorder.capacity.maxNrWaypointsPerTask) {
                            if (MessageBox.Show(this, string.Format("Too many waypoints ({0}) in task {1}. The max. capacity is {2}.\nIf you proceed, all further waypoints in this task will be ignored!\n\nProceed anyway?", 
                                t.Count - 2, t.Name, currentRecorder.capacity.maxNrWaypointsPerTask), "Capacity exeeded", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2) == DialogResult.No) {
                                return;
                            }
                        }
                    }
                }
                workerThread = currentRecorder.UploadTasksThread();
                RunThread();
            }
        }

        private void OnDownloadPilots(object sender, System.EventArgs e) {
            if (currentRecorder != null) {
                workerThread = currentRecorder.DownloadPilotsThread();
                RunThread();
            }
        }

        private void OnUploadPilots(object sender, System.EventArgs e) {
            if (currentRecorder != null) {
                currentRecorder.pilots.Clear();
                foreach (Pilot p in listBoxPilots.Items) {
                    currentRecorder.pilots.Add(p);
                }

                if (currentRecorder.capacity.maxNrPilots != (int)CapacityNumbers.Unlimited && currentRecorder.pilots.Count > currentRecorder.capacity.maxNrPilots) {
                    if (MessageBox.Show(this, string.Format("Too many pilots ({0}) in list. The max. capacity is {1}.\nIf you proceed, all further pilots will be ignored!\n\nProceed anyway?", 
                        currentRecorder.pilots.Count, currentRecorder.capacity.maxNrPilots), "Capacity exeeded", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2) == DialogResult.No) {
                        return;
                    }
                }
                workerThread = currentRecorder.UploadPilotsThread();
                RunThread();
            }
        }

        private void OnUploadSUA(object sender, System.EventArgs e) {
            if (currentRecorder != null) {
                currentRecorder.suas.Clear();
                foreach (ListViewItem it in listViewSUAs.Items) {
                    currentRecorder.suas.Add(it.Tag);
                }
                workerThread = currentRecorder.UploadSUASThread();
                RunThread();
            }
        }

        private void OnSaveFlights(object sender, System.EventArgs e) {
            if (currentRecorder != null) {
                FolderBrowserDialog fd = new FolderBrowserDialog();
                RegistryKey currentUser = Registry.CurrentUser.CreateSubKey("Software\\SoaringDotNet\\Path");

                fd.Description = "Select path for ICC files";                
                fd.SelectedPath = flightPath != "" ? flightPath : (string)currentUser.GetValue("DefaultFlightPath", "");;
                if (listViewFlightDirectory.SelectedIndices.Count > 0) {
                    if (fd.ShowDialog(this) == DialogResult.OK) {
                        flightPath = fd.SelectedPath;

                        currentRecorder.flightIndexes.Clear();
                        currentRecorder.flightIndexes.AddRange(listViewFlightDirectory.SelectedIndices);
                        currentRecorder.secureDownload = radioButtonSecure.Checked;
                        workerThread = currentRecorder.DownloadFlightsThread();
                        RunThread();
                    }
                }
                else {
                    MessageBox.Show(this, "Please select one or more flight's!", "SoaringDotNet", MessageBoxButtons.OK,
                        MessageBoxIcon.Exclamation);
                }
            }        
        }

        private void GetSerialNoHook(bool success) {
            if (success) {
                serialNo.Text = currentRecorder.SerialNo;
                connectionStatusPictureBox.Image = imageListConnectionStatus.Images[1];
            }
        }

        private void GetFlightDirectoryHook(bool success) {
            int i = 1;
            TimeSpan diffTime;
            listViewFlightDirectory.Items.Clear();
            if (success) {
                foreach (DirectoryEntry de in currentRecorder.flightDirectory) {
                    diffTime = de.lastFix - de.firstFix;
                    listViewFlightDirectory.Items.Add(new ListViewItem(new string [] {string.Format("{0}", i),
                                                                                         de.firstFix.ToShortDateString(),
                                                                                         de.pilot, 
                                                                                         string.Format("{0} ({1})", de.gliderId, de.competitionId),
                                                                                         de.firstFix.ToString("HH:mm:ss"),
                                                                                         de.lastFix.ToString("HH:mm:ss"),
                                                                                         string.Format("{0}:{1:00}:{2:00}", diffTime.Hours, diffTime.Minutes, diffTime.Seconds),
                                                                                         de.fileName}));
                    i++;
                }
            }
        }

        private void DownloadWaypointsHook(bool success) {
            if (success) {
                app.Invoke(app.AddWaypointCatalogueDelegate, new object [] {currentRecorder.currentCatalogue});
            }
        }

        private void UploadWaypointsHook(bool success) {
        }

        private void DownloadTasksHook(bool success) {
            if (success) {
                app.Invoke(app.AddTasksDelegate, new object [] {currentRecorder.tasks});
            }
        }

        private void DownloadPilotsHook(bool success) {
            if (success) {
                app.Invoke(app.AddPilotsDelegate, new object [] {currentRecorder.pilots});
            }
        }

        private void UploadTasksHook(bool success) {
        }

        private void UploadDeclarationHook(bool success) {
        }

        private void UploadSUAsHook(bool success) {
        }

        private void DownloadFlightsHook(bool success) {
            if (success) {
                DirectoryEntry de;
                string fileName;
                ArrayList fileNames = new ArrayList();
                foreach (int idx in currentRecorder.flightIndexes) {
                    de = (DirectoryEntry) currentRecorder.flightDirectory[idx];
                    fileName = flightPath + @"\" + de.fileName;
                    de.igcFile.Write(fileName);
                    fileNames.Add(fileName);
                }
                app.Invoke(app.AddFlightDelegate, new object [] {fileNames});
            }
        }

        private void UploadPilotsHook(bool success) {
        }

        private void RunThread() {
            abort = false;
            workerThread.IsBackground = true;

            panelConnection.Enabled = false;

            workerThread.Start();
            timer = new System.Threading.Timer(new TimerCallback(CheckStatus), this, 0, 10);
        }

        private void Disconnect() {
            if (currentRecorder != null) {
                currentRecorder.Close();
            }

            buttonDownloadTasks.Enabled = false;
            buttonDownloadWaypoints.Enabled = false;
            buttonReadFlightDir.Enabled = false;
            buttonSaveFlight.Enabled = false;
            buttonUploadDeclaration.Enabled = false;
            buttonUploadTasks.Enabled = false;
            buttonUploadWaypoints.Enabled = false;
            buttonUploadWaypoints.Enabled = false;
            buttonUploadSUA.Enabled = false;

            connectionStatusPictureBox.Image = imageListConnectionStatus.Images[0];
            listViewFlightDirectory.Items.Clear();
        }
	
        private void OnClickCancelTransfer(object sender, System.EventArgs e) {
            abort = true;
        }

        private void CheckStatus(object obj) {
            if (workerThread != null && (workerThread.IsAlive || workerThread.ThreadState == ThreadState.Unstarted)) {
                if (abort) {
                    currentRecorder.BreakTransfer();
                }

                if (progress.Value < progress.Maximum) {
                    progress.PerformStep();
                }
                else {
                    progress.Value = progress.Minimum;
                }
            }
            else {
                panelConnection.Enabled = true;

                progress.Value = progress.Minimum;
                timer.Dispose();
            }
        }

        private void OnSelectPilot1(object sender, System.EventArgs e) {
            SelectPilotDialog d = new SelectPilotDialog();
            if (d.ShowDialog(this) == DialogResult.OK) {
                textPilot1.Text = d.selectedPilot.FirstName.ToUpper() + " " + d.selectedPilot.LastName.ToUpper();
            }
        }

        private void OnSelectPilot2(object sender, System.EventArgs e) {
            SelectPilotDialog d = new SelectPilotDialog();
            if (d.ShowDialog(this) == DialogResult.OK) {
                textPilot2.Text = d.selectedPilot.FirstName.ToUpper() + " " + d.selectedPilot.LastName.ToUpper();
            }
        }

        private void OnSelectedTaskChanged(object sender, System.EventArgs e) {
            Task t = (Task)comboBoxTask.SelectedItem;
            int i;
            string txt;
            WayPoint wp;
            ListViewItem item;

            if (t != null) {
                if (listViewTask.Items.Count > t.Count) {
                    for (i = listViewTask.Items.Count - 1; i >= t.Count; i--) {
                        listViewTask.Items.RemoveAt(i);
                    }
                }
                else if (listViewTask.Items.Count < t.Count) {
                    for (i = listViewTask.Items.Count; i < t.Count; i++) {
                        listViewTask.Items.Add(new ListViewItem(new string []{"", "", "", ""}));
                    }
                }

                for (i = 0; i < t.Count; i++) {
                    if (i == 0) {
                        txt = "Takeoff";
                    }
                    else if (i == 1) {
                        txt = "Start";
                    }
                    else if (i == t.Count - 2) {
                        txt = "Finish";
                    }
                    else if (i == t.Count - 1) {
                        txt = "Landing";
                    }
                    else {
                        txt = "Turnpoint";                        
                    }

                    wp = t[i];
                    item = listViewTask.Items[i];
                    item.SubItems[0].Text = txt;
                    item.SubItems[1].Text = wp.longName;
                    item.SubItems[2].Text = wp.ToStringLat();
                    item.SubItems[3].Text = wp.ToStringLong();

                    labelTaskType.Text = t.TaskTypeString;
                }
            }
        }

        private void OnConnectRecorder(object sender, System.EventArgs e) {
            LineSpeed speed = LineSpeed.Baud_9600;
            string port;

            if (currentRecorder != null) {
                Disconnect();
            }

            currentRecorder = (RecorderBase) comboManufacturer.SelectedItem;
            if (currentRecorder != null) {
                switch (currentRecorder.ConnectionType) {
                case RecorderConnectionType.Serial:
                    if ((comboBoxBaud.SelectedItem == null || comboBoxPort.SelectedItem == null) && !currentRecorder.RedirectToFile) {
                        return;
                    }

                    switch(int.Parse(comboBoxBaud.SelectedItem != null ? comboBoxBaud.SelectedItem.ToString() : "0")) {
                    case 2400:
                        speed = LineSpeed.Baud_2400;
                        break;
                    case 4800:
                        speed = LineSpeed.Baud_4800;
                        break;
                    case 9600:
                        speed = LineSpeed.Baud_9600;
                        break;
                    case 19200:
                        speed = LineSpeed.Baud_19200;
                        break;
                    case 38400:
                        speed = LineSpeed.Baud_38400;
                        break;
                    case 57600:
                        speed = LineSpeed.Baud_57600;
                        break;
                    case 115200:
                        speed = LineSpeed.Baud_115200;
                        break;
                    default:
                        speed = LineSpeed.Baud_9600;
                        break;
                    }

                    port = comboBoxPort.SelectedItem != null ? comboBoxPort.SelectedItem.ToString() : "";
                    break;
                default:
                    return;
                }

                buttonDownloadTasks.Enabled = ((currentRecorder.Options & RecorderOptions.DownloadTasks) != 0);
                buttonDownloadPilots.Enabled = ((currentRecorder.Options & RecorderOptions.DownloadPilots) != 0);
                buttonDownloadWaypoints.Enabled = ((currentRecorder.Options & RecorderOptions.DownloadWaypoints) != 0);
                buttonReadFlightDir.Enabled = ((currentRecorder.Options & RecorderOptions.DownloadFlights) != 0);
                buttonSaveFlight.Enabled = ((currentRecorder.Options & RecorderOptions.DownloadFlights) != 0);
                buttonUploadDeclaration.Enabled = ((currentRecorder.Options & RecorderOptions.UploadDeclaration) != 0);
                buttonUploadTasks.Enabled = ((currentRecorder.Options & RecorderOptions.UploadTask) != 0);
                buttonUploadPilots.Enabled = ((currentRecorder.Options & RecorderOptions.UploadPilots) != 0);
                buttonUploadWaypoints.Enabled = ((currentRecorder.Options & RecorderOptions.UploadWaypoints) != 0);
                buttonUploadSUA.Enabled = ((currentRecorder.Options & RecorderOptions.UploadSUA) != 0);

                try {
                    if (port != "") {
                        currentRecorder.Open(port, speed);
                    }
                    workerThread = currentRecorder.SerialNoThread();
                    RunThread();
                }
                catch  (Exception ex) {
                    MessageBox.Show(ex.Message, "Connection Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    Disconnect();
                }
            }
        }

        private void OnSelectedAreaChanged(object sender, System.EventArgs e) {
            if (radioButtonCountry.Checked) {
                buttonUseAllCountries.Enabled = true;
                checkedListBoxCountry.Enabled = true;

                coordEditControlLatFrom.Enabled = false;
                coordEditControlLatTo.Enabled = false;
                coordEditControlLonFrom.Enabled  = false;
                coordEditControlLonTo.Enabled = false;
                checkBoxUseMapCoord.Enabled = false;
            }
            else {
                buttonUseAllCountries.Enabled = false;
                checkedListBoxCountry.Enabled = false;

                coordEditControlLatFrom.Enabled = true;
                coordEditControlLatTo.Enabled = true;
                coordEditControlLonFrom.Enabled  = true;
                coordEditControlLonTo.Enabled = true;
                checkBoxUseMapCoord.Enabled = true;
            }

            RecalcItems();
        }

        private void OnChangeArea(object sender, System.EventArgs e) {
            RecalcItems();
        }

        private void RecalcItems() {
            ListViewItem it;
            Hashtable controlledAirspace = new Hashtable();

            Cursor = Cursors.WaitCursor;

            controlledAirspace.Add(AirspaceTypes.ControlArea, null);
            controlledAirspace.Add(AirspaceTypes.ControlZone, null);
            controlledAirspace.Add(AirspaceTypes.TerminalControlArea, null);
            controlledAirspace.Add(AirspaceTypes.MilitaryAerodromeTraffic, null);

            bool useCountries = radioButtonCountry.Checked;
            if (!useCountries) {
                if ((coordEditControlLatFrom.Value != 0 || coordEditControlLatTo.Value != 0) &&
                    (coordEditControlLonFrom.Value != 0 || coordEditControlLonTo.Value != 0)) {
                    area.TopLat = coordEditControlLatFrom.Value;
                    area.LeftLon = coordEditControlLonFrom.Value;
                    area.BottomLat = coordEditControlLatTo.Value;
                    area.RightLon = coordEditControlLonTo.Value;
                }
                else {
                    area.Clear();
                }
            }

            listViewSUAs.BeginUpdate();
            listViewSUAs.Items.Clear();
            if (selectedAirspaces.Count > 0 || selectedClasses.Count > 0) {
                ArrayList items = new ArrayList(AppContents.airspaces.Count);
                if (useCountries) {
                    foreach (string country in selectedCountries.Keys) {
                        CountryTypeId id = (CountryTypeId)AppContents.countryTypesByCode[country];
                        foreach (AirspaceElement space in (ArrayList)AppContents.airspacesByCountry[id]) {
                            if (selectedAirspaces.ContainsKey(space.AirspaceType)) {
                                // controlled airspace must meet class criteria
                                if (controlledAirspace.ContainsKey(space.AirspaceType) && !selectedClasses.ContainsKey(space.AirspaceClass)) {
                                    continue;
                                }
                                it = new ListViewItem(new string [] {space.airspace.name, space.airspace.id, 
                                                                        space.AirspaceClass != AirspaceClasses.Unknown ? space.AirspaceClassString : "", 
                                                                        space.AirspaceTypeString, space.airspace.lowerBound, space.airspace.upperBound, 
                                                                        space.airspace.commName, space.airspace.radioFrequency, space.airspace.remark});
                                it.Tag = space;
                                items.Add(it);
                            }
                        }
                    }
                }
                else if (!area.IsEmpty) {
                    foreach (AirspaceElement space in AppContents.airspaces) {
                        if (area.AreaIntersect(space.Area)&& selectedAirspaces.ContainsKey(space.AirspaceType)) {
                            // controlled airspace must meet class criteria
                            if (controlledAirspace.ContainsKey(space.AirspaceType) && !selectedClasses.ContainsKey(space.AirspaceClass)) {
                                continue;
                            }
                            it = new ListViewItem(new string [] {space.airspace.name, space.airspace.id, 
                                                                    space.AirspaceClass != AirspaceClasses.Unknown ? space.AirspaceClassString : "", 
                                                                    space.AirspaceTypeString, space.airspace.lowerBound, space.airspace.upperBound,
                                                                    space.airspace.commName, space.airspace.radioFrequency, space.airspace.remark});
                            it.Tag = space;
                            items.Add(it);
                        }
                    }
                }
                if (items.Count > 0) {
                    listViewSUAs.Items.AddRange((ListViewItem [])items.ToArray(items[0].GetType()));
                }
            }
            labelSUAItems.Text = string.Format("{0} items", listViewSUAs.Items.Count);
            listViewSUAs.EndUpdate();

            Cursor = Cursors.Default;
        }

        private void OnKeyDownSUAs(object sender, System.Windows.Forms.KeyEventArgs e) {
            if (e.KeyCode == Keys.Delete) {
                foreach (ListViewItem it in listViewSUAs.SelectedItems) {
                    it.Remove();
                }
                labelSUAItems.Text = string.Format("{0} items", listViewSUAs.Items.Count);
            }
        }

        private void OnKeyDownTasks(object sender, System.Windows.Forms.KeyEventArgs e) {
            if (e.KeyCode == Keys.Delete) {
                foreach (ListViewItem it in listViewTasks.SelectedItems) {
                    it.Remove();
                }
            }
        }

        private void OnKeyDownPilots(object sender, System.Windows.Forms.KeyEventArgs e) {
            if (e.KeyCode == Keys.Delete) {
                int i;
                for (i = listBoxPilots.SelectedIndices.Count - 1; i >= 0; i--) {
                    listBoxPilots.Items.RemoveAt(listBoxPilots.SelectedIndices[i]);
                }
            }
        }

        private void OnItemCheckChanged(object sender, System.Windows.Forms.ItemCheckEventArgs e) {
            Country c = (Country)checkedListBoxCountry.Items[e.Index];
            if (e.NewValue == CheckState.Checked) {
                if (!selectedCountries.ContainsKey(c.code)) {
                    selectedCountries.Add(c.code, null);
                }
            }
            else {
                if (selectedCountries.ContainsKey(c.code)) {
                    selectedCountries.Remove(c.code);
                }
            }
            RecalcItems();
        }

        private void OnItemCheckChangedSUA(object sender, System.Windows.Forms.ItemCheckEventArgs e) {
            AirspaceTypes t = (AirspaceTypes)((IdType)checkedListBoxAirspaces.Items[e.Index]).id;
            if (e.NewValue == CheckState.Checked) {
                if (!selectedAirspaces.ContainsKey(t)) {
                    selectedAirspaces.Add(t, null);
                }
            }
            else {
                if (selectedAirspaces.ContainsKey(t)) {
                    selectedAirspaces.Remove(t);
                }
            }
            RecalcItems();
        }

        private void OnItemCheckChangedClasses(object sender, System.Windows.Forms.ItemCheckEventArgs e) {
            AirspaceClasses c = (AirspaceClasses)((IdType)checkedListBoxClasses.Items[e.Index]).id;
            if (e.NewValue == CheckState.Checked) {
                if (!selectedClasses.ContainsKey(c)) {
                    selectedClasses.Add(c, null);
                }
            }
            else {
                if (selectedClasses.ContainsKey(c)) {
                    selectedClasses.Remove(c);
                }
            }
            RecalcItems();
        }

        private void OnUseAllCountries(object sender, System.EventArgs e) {
            Country c;
            selectedCountries.Clear();
            refresh = false;
            for (int i = 0; i < checkedListBoxCountry.Items.Count; i++) {
                checkedListBoxCountry.SetItemChecked(i, true);
                c = (Country)checkedListBoxCountry.Items[i];
                if (!selectedCountries.ContainsKey(c.code)) {
                    selectedCountries.Add(c.code, null);
                }
            }
            refresh = true;
            RecalcItems();
        }

        private void OnReloadTasks(object sender, System.EventArgs e) {
            string txt = "";
            int i;

            listViewTasks.Items.Clear();
            comboBoxTask.Items.Clear();

            foreach (Task t in AppContents.tasks) {
                if (t.Count > 0) {
                    txt = t[0].longName;
                    for (i = 1; i < t.Count; i++) {
                        txt += ", " + t[i].longName;
                    }
                }
                else {
                    txt = "";
                }

                ListViewItem it = new ListViewItem(new string [] {t.Name, t.TaskTypeString, txt});
                it.Tag = t;
                listViewTasks.Items.Add(it);
                comboBoxTask.Items.Add(t);
            }
        }

        private void OnReloadPilots(object sender, System.EventArgs e) {
            listBoxPilots.Items.Clear();
            foreach(Pilot p in AppContents.pilots) {
                listBoxPilots.Items.Add(p);
            }
        }

        private void OnCreateFilesCheckChanged(object sender, System.EventArgs e) {
            if (checkBoxRedirectToFile.Checked) {
                comboBoxBaud.Enabled = false;
                comboBoxPort.Enabled = false;
            }
            else {
                comboBoxBaud.Enabled = true;
                comboBoxPort.Enabled = true;
            }

            if (currentRecorder != null) {
                currentRecorder.RedirectToFile = checkBoxRedirectToFile.Checked;
            }
            OnConnectRecorder(null, null);
        }

        private void OnConnectionChanged(object sender, System.EventArgs e) {
            if (currentRecorder != null) {
                Disconnect();
            }
        }

        private void OnUseAllAirspaces(object sender, System.EventArgs e) {
            refresh = false;
            AirspaceTypes t;
            selectedAirspaces.Clear();
            for (int i = 0; i < checkedListBoxAirspaces.Items.Count; i++) {
                checkedListBoxAirspaces.SetItemChecked(i, true);
                t = (AirspaceTypes)((IdType)checkedListBoxAirspaces.Items[i]).id;
                if (!selectedAirspaces.ContainsKey(t)) {
                    selectedAirspaces.Add(t, null);
                }
            }

            refresh = true;
            RecalcItems();
        }

        private void OnUseAllClasses(object sender, System.EventArgs e) {
            refresh = false;
            AirspaceClasses c;
            selectedClasses.Clear();
            for (int i = 0; i < checkedListBoxClasses.Items.Count; i++) {
                checkedListBoxClasses.SetItemChecked(i, true);
                c = (AirspaceClasses)((IdType)checkedListBoxClasses.Items[i]).id;
                if (!selectedClasses.ContainsKey(c)) {
                    selectedClasses.Add(c, null);
                }
            }

            refresh = true;
            RecalcItems();
        }

        private void OnColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e) {
            ListView lv = (ListView) sender;
            ListViewItemSorter sorter = (ListViewItemSorter)lv.ListViewItemSorter;
            if (sorter != null) {
                sorter.Col = e.Column;
                lv.Sort();
            }
        }

        private void OnUseMapArea(object sender, System.EventArgs e) {
            if (checkBoxUseMapCoord.Checked) {
                coordEditControlLatFrom.Value = app.MapUpperLeft.Y;
                coordEditControlLatTo.Value = app.MapLowerRight.Y;
                coordEditControlLonFrom.Value = app.MapUpperLeft.X;
                coordEditControlLonTo.Value = app.MapLowerRight.X;
            }
            else {
                coordEditControlLatFrom.Value = 0;
                coordEditControlLatTo.Value = 0;
                coordEditControlLonFrom.Value = 0;
                coordEditControlLonTo.Value = 0;
            }

            RecalcItems();
        }
        #endregion

        private void OnSUAVisibleChanged(object sender, System.EventArgs e) {
            if (panelSUA.Visible) {
                if (checkBoxUseMapCoord.Checked) {
                    OnUseMapArea(null, null);
                }
            }
        }

        #region Attributes
        public SoaringDotNet App {
            get {
                return app;
            }
            set {
                app = value;
            }
        }
        #endregion
    }
}
